/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.helper.BlockPosHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.misc.TelepathicUtils;
import net.tardis.mod.tileentities.ConsoleTile;

public class TelepathicMessage {
    private static final TranslationTextComponent VALID = new TranslationTextComponent("message.tardis.telepathic.success");
    private static final String NOT_FOUND = "message.tardis.telepathic.not_found";
    private String name;
    private TelepathicUtils.SearchType type;

    public TelepathicMessage(TelepathicUtils.SearchType type, String key) {
        this.name = key;
        this.type = type;
    }

    public static void encode(TelepathicMessage mes, PacketBuffer buf) {
        buf.writeInt(mes.type.ordinal());
        buf.func_211400_a(mes.name, 64);
    }

    public static TelepathicMessage decode(PacketBuffer buf) {
        return new TelepathicMessage(TelepathicUtils.SearchType.values[buf.readInt()], buf.func_150789_c(64));
    }

    public static void handle(TelepathicMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> {
            ConsoleTile console;
            ServerWorld world;
            TileEntity te = ((NetworkEvent.Context)cont.get()).getSender().field_70170_p.func_175625_s(TardisHelper.TARDIS_POS);
            if (te instanceof ConsoleTile && (world = (console = (ConsoleTile)te).func_145831_w().func_73046_m().func_71218_a(console.getDestinationDimension())) != null) {
                BlockPos dest = console.getDestinationPosition();
                ServerPlayerEntity player = ((NetworkEvent.Context)cont.get()).getSender();
                int rangeLimit = 500;
                int rangeLimitChunks = (byte)((double)rangeLimit / 16.0) << 2;
                switch (mes.type) {
                    case BIOME: {
                        ArrayList list = Lists.newArrayList();
                        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation(mes.name));
                        Biome destBiome = (Biome)world.func_73046_m().func_244267_aX().func_243612_b(Registry.field_239720_u_).func_243576_d(biomeKey);
                        list.add(destBiome);
                        BiomeProvider biomeProvider = world.func_72863_F().func_201711_g().func_202090_b();
                        BlockPos biome = biomeProvider.func_230321_a_(dest.func_177958_n(), dest.func_177956_o(), dest.func_177952_p(), rangeLimitChunks, 1, list::contains, world.field_73012_v, true);
                        if (biome != null) {
                            console.setDestination(console.getDestinationDimension(), biome.func_177981_b(64));
                            player.func_146105_b((ITextComponent)VALID, true);
                            break;
                        }
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(NOT_FOUND, new Object[]{mes.type.toString().toUpperCase(), rangeLimit}), true);
                        break;
                    }
                    case SPAWN: {
                        BlockPos spawn = world.func_241135_u_();
                        if (spawn == null) break;
                        console.setDestination(console.getDestinationDimension(), console.randomizeCoords(spawn, 25));
                        player.func_146105_b((ITextComponent)VALID, true);
                        break;
                    }
                    case STRUCTURE: {
                        int structureSearchRange = 256;
                        int structureSearchRangeChunks = (int)((double)structureSearchRange / 16.0);
                        RegistryKey structureKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243553_av, (ResourceLocation)new ResourceLocation(mes.name));
                        Structure structureToSearch = ((StructureFeature)world.func_73046_m().func_244267_aX().func_243612_b((RegistryKey)Registry.field_243553_av).func_243576_d((RegistryKey)structureKey)).field_236268_b_;
                        BlockPos pos = world.func_241117_a_(structureToSearch, console.getDestinationPosition(), structureSearchRangeChunks, false);
                        if (pos != null) {
                            BlockPos landSpot;
                            List<BlockPos> possibleLandSpots = BlockPosHelper.getFilteredBlockPositionsInStructure(pos, world, world.func_241112_a_(), structureToSearch, (Block)TBlocks.landing_pad.get());
                            if (!possibleLandSpots.isEmpty()) {
                                int index = world.field_73012_v.nextInt(possibleLandSpots.size());
                                landSpot = possibleLandSpots.get(index);
                            } else {
                                landSpot = pos;
                            }
                            console.setDestination(console.getDestinationDimension(), landSpot);
                            player.func_146105_b((ITextComponent)VALID, true);
                            break;
                        }
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(NOT_FOUND, new Object[]{mes.type.toString().toUpperCase(), structureSearchRange}), true);
                        break;
                    }
                }
            }
        });
        cont.get().setPacketHandled(true);
    }
}

