/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.client.ClientPacketHandler;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.TelepathicUtils;

public class TelepathicGetStructuresMessage {
    private static final int STRING_SIZE = Short.MAX_VALUE;
    private List<TelepathicUtils.Search> names = new ArrayList<TelepathicUtils.Search>();

    public TelepathicGetStructuresMessage(List<TelepathicUtils.Search> names) {
        this.names.clear();
        this.names.addAll(names);
    }

    public static TelepathicGetStructuresMessage create(MinecraftServer server, World world) {
        ArrayList<TelepathicUtils.Search> list = new ArrayList<TelepathicUtils.Search>();
        server.func_244267_aX().func_243612_b(Registry.field_243553_av).func_239659_c_().stream().forEach(entry -> list.add(new TelepathicUtils.Search((ITextComponent)new StringTextComponent(WorldHelper.formatStructureKey((RegistryKey)entry.getKey())), ((RegistryKey)entry.getKey()).func_240901_a_().toString(), TelepathicUtils.SearchType.STRUCTURE)));
        return new TelepathicGetStructuresMessage(list);
    }

    public static void encode(TelepathicGetStructuresMessage mes, PacketBuffer buf) {
        buf.writeInt(mes.names.size());
        for (TelepathicUtils.Search e : mes.names) {
            buf.func_211400_a(e.key, Short.MAX_VALUE);
            buf.writeInt(e.type.ordinal());
        }
    }

    public static TelepathicGetStructuresMessage decode(PacketBuffer buf) {
        int size = buf.readInt();
        ArrayList<TelepathicUtils.Search> names = new ArrayList<TelepathicUtils.Search>();
        for (int i = 0; i < size; ++i) {
            String key = buf.func_150789_c(Short.MAX_VALUE);
            TelepathicUtils.SearchType type = TelepathicUtils.SearchType.values()[buf.readInt()];
            names.add(new TelepathicUtils.Search((ITextComponent)new StringTextComponent(WorldHelper.formatStructureKey(key)), key, type));
        }
        return new TelepathicGetStructuresMessage(names);
    }

    public static void handle(TelepathicGetStructuresMessage mes, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientPacketHandler.handleTelepathicStructureNames(mes));
        context.get().setPacketHandled(true);
    }

    public List<TelepathicUtils.Search> getSearchNames() {
        return this.names;
    }
}

