/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.ClientPacketHandler;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.subsystem.AntennaSubsystem;

public class TardisNameGuiMessage {
    private static final int STRING_SIZE = Short.MAX_VALUE;
    private Map<ResourceLocation, String> names = Maps.newHashMap();

    public TardisNameGuiMessage(Map<ResourceLocation, String> names) {
        this.names.clear();
        this.names.putAll(names);
    }

    public static TardisNameGuiMessage create(MinecraftServer server) {
        HashMap map = Maps.newHashMap();
        for (ServerWorld world : TardisHelper.getTardises(server)) {
            TardisHelper.getConsoleInWorld((World)world).ifPresent(tile -> world.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> tile.getSubsystem(AntennaSubsystem.class).ifPresent(sys -> {
                if (sys.canBeUsed()) {
                    map.put(world.func_234923_W_().func_240901_a_(), data.getTARDISName());
                }
            })));
        }
        return new TardisNameGuiMessage(map);
    }

    public static void encode(TardisNameGuiMessage mes, PacketBuffer buf) {
        buf.writeInt(mes.names.size());
        for (Map.Entry<ResourceLocation, String> e : mes.names.entrySet()) {
            buf.func_192572_a(e.getKey());
            buf.func_211400_a(e.getValue(), Short.MAX_VALUE);
        }
    }

    public static TardisNameGuiMessage decode(PacketBuffer buf) {
        int size = buf.readInt();
        HashMap names = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            names.put(buf.func_192575_l(), buf.func_150789_c(Short.MAX_VALUE));
        }
        return new TardisNameGuiMessage(names);
    }

    public static void handle(TardisNameGuiMessage mes, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientPacketHandler.handleClientSideNames(mes));
        context.get().setPacketHandled(true);
    }

    public Map<ResourceLocation, String> getNames() {
        return this.names;
    }
}

