/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.misc.TardisLike;

public class TardisLikeSyncMessage {
    private Map<ResourceLocation, TardisLike> likes = new HashMap<ResourceLocation, TardisLike>();
    public static final Codec<Map<ResourceLocation, TardisLike>> MAPPER = Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, TardisLike.getCodec());

    public TardisLikeSyncMessage(Map<ResourceLocation, TardisLike> likes) {
        this.likes.clear();
        this.likes.putAll(likes);
    }

    public static void encode(TardisLikeSyncMessage mes, PacketBuffer buf) {
        buf.func_150786_a(MAPPER.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, mes.likes).result().orElse(new CompoundNBT()));
    }

    public static TardisLikeSyncMessage decode(PacketBuffer buf) {
        return new TardisLikeSyncMessage(MAPPER.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)buf.func_150793_b()).result().orElse(TardisLike.registerCoreEntries()));
    }

    public static void handle(TardisLikeSyncMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> TardisLike.DATA_LOADER.setData(mes.likes));
        cont.get().setPacketHandled(true);
    }
}

