/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.cap.items.sonic.SonicCapability;

public class SyncSonicMessage {
    public CompoundNBT data;
    public Hand hand;
    public UUID playerID;
    public int index;
    public IInventory inv;

    public SyncSonicMessage(Hand hand, CompoundNBT data, UUID playerID) {
        this.hand = hand;
        this.data = data;
        this.playerID = playerID;
    }

    public static void encode(SyncSonicMessage mes, PacketBuffer buffer) {
        buffer.writeInt(mes.hand.ordinal());
        buffer.func_150786_a(mes.data);
        buffer.func_179252_a(mes.playerID);
    }

    public static SyncSonicMessage decode(PacketBuffer buffer) {
        return new SyncSonicMessage(Hand.values()[buffer.readInt()], buffer.func_150793_b(), buffer.func_179253_g());
    }

    public static void handle(SyncSonicMessage mes, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = Minecraft.func_71410_x().field_71441_e.func_217371_b(mes.playerID);
            if (player != null) {
                SonicCapability.getForStack(player.func_184586_b(mes.hand)).ifPresent(cap -> cap.deserializeNBT((INBT)mes.data));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

