/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.items.SonicItem;
import net.tardis.mod.items.sonicparts.SonicBasePart;
import net.tardis.mod.sonic.ISonicPart;

public class SonicPartChangeMessage {
    ItemStack stack;
    BlockPos pos;
    int slot;

    public SonicPartChangeMessage(ItemStack stack, int slot, BlockPos pos) {
        this.stack = stack;
        this.pos = pos;
        this.slot = slot;
    }

    public static void encode(SonicPartChangeMessage mes, PacketBuffer buf) {
        buf.func_150788_a(mes.stack);
        buf.writeInt(mes.slot);
        buf.func_179255_a(mes.pos);
    }

    public static SonicPartChangeMessage decode(PacketBuffer buf) {
        return new SonicPartChangeMessage(buf.func_150791_c(), buf.readInt(), buf.func_179259_c());
    }

    public static void handle(SonicPartChangeMessage mes, Supplier<NetworkEvent.Context> con) {
        con.get().enqueueWork(() -> {
            IItemHandlerModifiable workbench;
            ItemStack sonic;
            TileEntity te = ((NetworkEvent.Context)con.get()).getSender().field_70170_p.func_175625_s(mes.pos);
            if (te instanceof IItemHandlerModifiable && (sonic = (workbench = (IItemHandlerModifiable)te).getStackInSlot(0)).func_77973_b() instanceof SonicItem) {
                sonic.getCapability(Capabilities.SONIC_CAPABILITY).ifPresent(cap -> {
                    int type = SonicBasePart.getType(mes.stack);
                    cap.setSonicPart(SonicBasePart.SonicComponentTypes.getFromID(type), ISonicPart.SonicPart.getFromItem(mes.stack.func_77973_b()));
                    SonicItem.syncCapability(sonic);
                });
            }
        });
        con.get().setPacketHandled(true);
    }
}

