/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.items.SonicItem;
import net.tardis.mod.sonic.AbstractSonicMode;

public class SonicModeChangeMessage {
    private AbstractSonicMode mode;
    private int entityID;

    public SonicModeChangeMessage(AbstractSonicMode mode, int entityID) {
        this.mode = mode;
        this.entityID = entityID;
    }

    public static void encode(SonicModeChangeMessage mes, PacketBuffer buf) {
        buf.writeRegistryId((IForgeRegistryEntry)mes.mode);
        buf.writeInt(mes.entityID);
    }

    public static SonicModeChangeMessage decode(PacketBuffer buf) {
        return new SonicModeChangeMessage((AbstractSonicMode)buf.readRegistryId(), buf.readInt());
    }

    public static void handle(SonicModeChangeMessage mes, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity = ((NetworkEvent.Context)context.get()).getSender().func_130014_f_().func_73045_a(mes.entityID);
            if (entity instanceof LivingEntity) {
                LivingEntity liv = (LivingEntity)entity;
                SonicModeChangeMessage.setModeToSonic(liv.func_184614_ca(), mes.mode);
                SonicModeChangeMessage.setModeToSonic(liv.func_184592_cb(), mes.mode);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void setModeToSonic(ItemStack stack, AbstractSonicMode entry) {
        stack.getCapability(Capabilities.SONIC_CAPABILITY).ifPresent(cap -> {
            cap.setMode(entry);
            SonicItem.syncCapability(stack);
        });
    }
}

