/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.network.packets.exterior.DoorData;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;
import net.tardis.mod.world.dimensions.TDimensions;

public class SnapMessage {
    public static void encode(SnapMessage mes, PacketBuffer buf) {
    }

    public static SnapMessage decode(PacketBuffer buf) {
        return new SnapMessage();
    }

    public static void handle(SnapMessage mes, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerWorld world = ((NetworkEvent.Context)context.get()).getSender().func_71121_q();
            MinecraftServer server = ((NetworkEvent.Context)context.get()).getSender().func_184102_h();
            if (WorldHelper.areDimensionTypesSame((World)world, TDimensions.DimensionTypes.TARDIS_TYPE)) {
                TardisHelper.getConsoleInWorld((World)world).ifPresent(arg_0 -> SnapMessage.lambda$null$1(mes, (Supplier)context, world, arg_0));
            } else {
                ArrayList<TileEntity> tiles = new ArrayList<TileEntity>(world.field_147482_g);
                tiles.removeIf(arg_0 -> SnapMessage.lambda$null$2((Supplier)context, arg_0));
                for (TileEntity te : tiles) {
                    if (!(te instanceof ExteriorTile)) continue;
                    ExteriorTile ext = (ExteriorTile)te;
                    TardisHelper.getConsole(server, ext.getInteriorDimensionKey()).ifPresent(arg_0 -> SnapMessage.lambda$null$3((Supplier)context, ext, world, arg_0));
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static boolean canPlayerUseSnap(PlayerEntity player, ConsoleTile tile) {
        return tile.getEmotionHandler().getLoyalty(player.func_110124_au()) >= 100 && !tile.getInteriorManager().isInteriorStillRegenerating();
    }

    private static void playSnapSound(ServerWorld world, BlockPos pos, float volume, float pitch) {
        world.func_184133_a(null, pos, (SoundEvent)TSounds.SNAP.get(), SoundCategory.BLOCKS, volume, pitch);
    }

    private static /* synthetic */ void lambda$null$3(Supplier context, ExteriorTile ext, ServerWorld world, ConsoleTile console) {
        if (SnapMessage.canPlayerUseSnap((PlayerEntity)((NetworkEvent.Context)context.get()).getSender(), console)) {
            boolean open = ext.getOpen() != EnumDoorState.CLOSED;
            ext.setLocked(open);
            ext.setDoorState(open ? EnumDoorState.CLOSED : EnumDoorState.BOTH);
            ext.copyDoorStateToInteriorDoor();
            ext.updateSpecific(DoorData.create(ext));
            SnapMessage.playSnapSound(world, ((NetworkEvent.Context)context.get()).getSender().func_233580_cy_(), 0.5f, 1.0f);
        }
    }

    private static /* synthetic */ boolean lambda$null$2(Supplier context, TileEntity tile) {
        return tile.func_174877_v().func_177951_i((Vector3i)((NetworkEvent.Context)context.get()).getSender().func_233580_cy_()) > 400.0;
    }

    private static /* synthetic */ void lambda$null$1(SnapMessage mes, Supplier context, ServerWorld world, ConsoleTile console) {
        if (SnapMessage.canPlayerUseSnap((PlayerEntity)((NetworkEvent.Context)context.get()).getSender(), console)) {
            console.getDoor().ifPresent(arg_0 -> SnapMessage.lambda$null$0(world, (Supplier)context, arg_0));
        }
    }

    private static /* synthetic */ void lambda$null$0(ServerWorld world, Supplier context, DoorEntity door) {
        boolean open = door.getOpenState() != EnumDoorState.CLOSED;
        door.setLocked(open);
        door.setOpenState(open ? EnumDoorState.CLOSED : EnumDoorState.BOTH);
        door.updateExteriorDoorData();
        SnapMessage.playSnapSound(world, ((NetworkEvent.Context)context.get()).getSender().func_233580_cy_(), 0.5f, 1.0f);
    }
}

