/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.missions.MiniMission;

public class SetMissionObjectiveMessage {
    private BlockPos pos;
    private int objective;
    private ResourceLocation stage;

    public SetMissionObjectiveMessage(BlockPos pos, int objective, ResourceLocation stage) {
        this.pos = pos;
        this.objective = objective;
        this.stage = stage;
    }

    public static void encode(SetMissionObjectiveMessage mes, PacketBuffer buffer) {
        buffer.func_179255_a(mes.pos);
        buffer.writeInt(mes.objective);
        buffer.func_192572_a(mes.stage);
    }

    public static SetMissionObjectiveMessage decode(PacketBuffer buf) {
        return new SetMissionObjectiveMessage(buf.func_179259_c(), buf.readInt(), buf.func_192575_l());
    }

    public static void handle(SetMissionObjectiveMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> ((NetworkEvent.Context)cont.get()).getSender().func_71121_q().getCapability(Capabilities.MISSION).ifPresent(mission -> {
            MiniMission mis = mission.getMissionForPos(mes.pos);
            if (mis != null) {
                mis.setObjectiveForStage(mes.stage, mes.objective);
            }
        }));
        cont.get().setPacketHandled(true);
    }
}

