/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.subsystem.AntennaSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.DistressSignal;

public class SendTardisDistressSignal {
    String message;
    ResourceLocation tardis;

    public SendTardisDistressSignal(String message, @Nullable ResourceLocation tardis) {
        this.message = message;
        this.tardis = tardis;
    }

    public static void encode(SendTardisDistressSignal mes, PacketBuffer buf) {
        int size = mes.message.length();
        buf.writeInt(size);
        buf.func_211400_a(mes.message, size);
        boolean hasID = mes.tardis != null;
        buf.writeBoolean(hasID);
        if (hasID) {
            buf.func_192572_a(mes.tardis);
        }
    }

    public static SendTardisDistressSignal decode(PacketBuffer buf) {
        int size = buf.readInt();
        String message = buf.func_150789_c(size);
        ResourceLocation id = null;
        boolean hasID = buf.readBoolean();
        if (hasID) {
            id = buf.func_192575_l();
        }
        return new SendTardisDistressSignal(message, id);
    }

    public static void handle(SendTardisDistressSignal mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> TardisHelper.getConsoleInWorld((World)((NetworkEvent.Context)cont.get()).getSender().func_71121_q()).ifPresent(arg_0 -> SendTardisDistressSignal.lambda$null$3(mes, (Supplier)cont, arg_0)));
        cont.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$3(SendTardisDistressSignal mes, Supplier cont, ConsoleTile tile) {
        DistressSignal signal = new DistressSignal(mes.message, tile.getPositionInFlight());
        tile.getSubsystem(AntennaSubsystem.class).ifPresent(arg_0 -> SendTardisDistressSignal.lambda$null$2(mes, (Supplier)cont, signal, arg_0));
    }

    private static /* synthetic */ void lambda$null$2(SendTardisDistressSignal mes, Supplier cont, DistressSignal signal, AntennaSubsystem sys) {
        if (sys.canBeUsed()) {
            ResourceLocation tardis = mes.tardis;
            if (tardis == null) {
                for (ServerWorld world : TardisHelper.getTardises(((NetworkEvent.Context)cont.get()).getSender().func_184102_h())) {
                    TardisHelper.getConsoleInWorld((World)world).ifPresent(other -> other.addDistressSignal(signal));
                }
            } else {
                TardisHelper.getConsole(((NetworkEvent.Context)cont.get()).getSender().func_184102_h(), tardis).ifPresent(other -> other.addDistressSignal(signal));
            }
        }
    }
}

