/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.network.packets.data.Requestors.Requestor;

public class RequestTileDataMessage {
    private static final HashMap<Integer, Requestor<?>> REQUESTORS = Maps.newHashMap();
    private static int ID = 0;
    public Requestor<?> request;
    public BlockPos pos;

    public RequestTileDataMessage(Requestor<?> request, BlockPos pos) {
        this.request = request;
        this.pos = pos;
    }

    public static void encode(RequestTileDataMessage mes, PacketBuffer buf) {
        Requestor<?> request = mes.request;
        buf.writeInt(request.getId());
        buf.func_179255_a(mes.pos);
    }

    public static RequestTileDataMessage decode(PacketBuffer buf) {
        Requestor<?> request = REQUESTORS.get(buf.readInt());
        return new RequestTileDataMessage(request, buf.func_179259_c());
    }

    public static void handle(RequestTileDataMessage mes, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            TileEntity te = ((NetworkEvent.Context)context.get()).getSender().func_71121_q().func_175625_s(mes.pos);
            if (te != null) {
                mes.request.isValid(te).ifPresent(arg_0 -> RequestTileDataMessage.lambda$null$0(mes, (Supplier)context, arg_0));
            }
        });
        context.get().setPacketHandled(true);
    }

    public static <T extends Requestor<?>> T registerRequestor(T request) {
        int id = RequestTileDataMessage.id();
        request.setId(id);
        REQUESTORS.put(id, request);
        return request;
    }

    public static int id() {
        return ++ID;
    }

    private static /* synthetic */ void lambda$null$0(RequestTileDataMessage mes, Supplier context, TileEntity tile) {
        mes.request.tryToActOnTile(tile, ((NetworkEvent.Context)context.get()).getSender());
    }
}

