/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.protocols.Protocol;
import net.tardis.mod.registries.ProtocolRegistry;
import net.tardis.mod.tileentities.ConsoleTile;

public class ProtocolMessage {
    public ResourceLocation protocol;

    public ProtocolMessage(ResourceLocation protocol) {
        this.protocol = protocol;
    }

    public static ProtocolMessage decode(PacketBuffer buf) {
        return new ProtocolMessage(buf.func_192575_l());
    }

    public static void encode(ProtocolMessage mes, PacketBuffer buf) {
        buf.func_192572_a(mes.protocol);
    }

    public static void handle(ProtocolMessage mes, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Protocol prot;
            ServerWorld world = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q();
            TileEntity te = world.func_175625_s(TardisHelper.TARDIS_POS);
            if (te instanceof ConsoleTile && (prot = (Protocol)ProtocolRegistry.PROTOCOL_REGISTRY.get().getValue(mes.protocol)) != null) {
                prot.call((World)world, (PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), (ConsoleTile)te);
            }
        });
    }
}

