/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.client.ClientPacketHandler;
import net.tardis.mod.missions.MiniMission;

public class MissionUpdateMessage {
    private BlockPos pos;
    private ResourceLocation key;
    private int range;
    private CompoundNBT nbt;

    public BlockPos getPos() {
        return this.pos;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public int getRange() {
        return this.range;
    }

    public CompoundNBT getNBT() {
        return this.nbt;
    }

    public MissionUpdateMessage(BlockPos pos, ResourceLocation key, int range, CompoundNBT nbt) {
        this.pos = pos;
        this.key = key;
        this.range = range;
        this.nbt = nbt;
    }

    public MissionUpdateMessage(MiniMission mis) {
        this(mis.getPos(), mis.getType().getRegistryName(), mis.getRange(), mis.serializeNBT());
    }

    public static void encode(MissionUpdateMessage mes, PacketBuffer buf) {
        buf.func_179255_a(mes.pos);
        buf.func_192572_a(mes.key);
        buf.writeInt(mes.range);
        buf.func_150786_a(mes.nbt);
    }

    public static MissionUpdateMessage decode(PacketBuffer buf) {
        return new MissionUpdateMessage(buf.func_179259_c(), buf.func_192575_l(), buf.readInt(), buf.func_150793_b());
    }

    public static void handle(MissionUpdateMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> ClientPacketHandler.handleMissionUpdateClient(mes));
        cont.get().setPacketHandled(true);
    }
}

