/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.client.ClientPacketHandler;
import net.tardis.mod.enums.EnumMatterState;

public class MaterializationMessage {
    public EnumMatterState state;
    public BlockPos pos;
    public int materializeTime;
    public int maxMaterializeTime;

    public MaterializationMessage(BlockPos pos, EnumMatterState matterState, int materializeTime, int maxMaterializeTime) {
        this.pos = pos;
        this.state = matterState;
        this.materializeTime = materializeTime;
        this.maxMaterializeTime = maxMaterializeTime;
    }

    public static void encode(MaterializationMessage mes, PacketBuffer buf) {
        buf.func_179255_a(mes.pos);
        buf.func_179249_a((Enum)mes.state);
        buf.writeInt(mes.materializeTime);
        buf.writeInt(mes.maxMaterializeTime);
    }

    public static MaterializationMessage decode(PacketBuffer buf) {
        return new MaterializationMessage(buf.func_179259_c(), (EnumMatterState)buf.func_179257_a(EnumMatterState.class), buf.readInt(), buf.readInt());
    }

    public static void handle(MaterializationMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> ClientPacketHandler.handleMaterializationPacket(mes.pos, mes.state, mes.materializeTime, mes.maxMaterializeTime));
        cont.get().setPacketHandled(true);
    }
}

