/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.damagesources.TDamageSources;
import net.tardis.mod.tileentities.inventory.PanelInventory;

public class FailEngineMessage {
    int slot = 0;
    Direction dir;

    public FailEngineMessage(Direction dir, int slot) {
        this.slot = slot;
        this.dir = dir;
    }

    public static void encode(FailEngineMessage mes, PacketBuffer buf) {
        buf.writeInt(mes.dir.func_176745_a());
        buf.writeInt(mes.slot);
    }

    public static FailEngineMessage decode(PacketBuffer buf) {
        return new FailEngineMessage(Direction.func_82600_a((int)buf.readInt()), buf.readInt());
    }

    public static void handle(FailEngineMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)cont.get()).getSender();
            player.func_71121_q().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                PanelInventory inv = data.getEngineInventoryForSide(mes.dir);
                InventoryHelper.func_180173_a((World)player.func_71121_q(), (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)inv.getStackInSlot(mes.slot));
                inv.setStackInSlot(mes.slot, ItemStack.field_190927_a);
                player.func_70097_a(TDamageSources.CIRCUITS, 1.0f);
            });
        });
        cont.get().setPacketHandled(true);
    }
}

