/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.subsystem.ChameleonSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;

public class ExteriorChangeMessage {
    ResourceLocation exterior;

    public ExteriorChangeMessage(ResourceLocation ext) {
        this.exterior = ext;
    }

    public static void encode(ExteriorChangeMessage mes, PacketBuffer buf) {
        buf.func_192572_a(mes.exterior);
    }

    public static ExteriorChangeMessage decode(PacketBuffer buf) {
        return new ExteriorChangeMessage(buf.func_192575_l());
    }

    public static void handle(ExteriorChangeMessage mes, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            TileEntity te = ((NetworkEvent.Context)context.get()).getSender().func_71121_q().func_175625_s(TardisHelper.TARDIS_POS);
            if (te instanceof ConsoleTile) {
                ConsoleTile console = (ConsoleTile)te;
                console.getSubsystem(ChameleonSubsystem.class).ifPresent(arg_0 -> ExteriorChangeMessage.lambda$null$0(mes, console, (Supplier)context, arg_0));
            }
        });
        context.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$0(ExteriorChangeMessage mes, ConsoleTile console, Supplier context, ChameleonSubsystem sys) {
        AbstractExterior ext = ExteriorRegistry.getExterior(mes.exterior);
        if (console.getUnlockManager().getUnlockedExteriors().contains((Object)ext)) {
            if (sys.canBeUsed()) {
                boolean hasExt;
                sys.damage(((NetworkEvent.Context)context.get()).getSender(), 1);
                boolean bl = hasExt = console.getExteriorType().getExteriorTile(console) != null;
                if (hasExt) {
                    console.getExteriorType().remove(console);
                }
                console.setExteriorType(ext);
                if (!console.isInFlight()) {
                    console.getExteriorType().place(console, console.getCurrentDimension(), console.getCurrentLocation());
                }
            } else {
                ((NetworkEvent.Context)context.get()).getSender().func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.no_subsystem", new Object[]{TardisConstants.Translations.CHAMELEON_CIRCUIT.getString()}), true);
            }
        }
    }
}

