/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.ClientPacketHandler;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.network.Network;
import net.tardis.mod.registries.UpgradeRegistry;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.upgrades.Upgrade;
import net.tardis.mod.upgrades.UpgradeEntry;

public class EngineSliderSyncMessage {
    public int maxSlotSize;
    public Map<Integer, Boolean> upgradeStates = new HashMap<Integer, Boolean>();

    public EngineSliderSyncMessage(int maxSlotSize, Map<Integer, Boolean> upgradeStates) {
        this.maxSlotSize = maxSlotSize;
        this.upgradeStates = upgradeStates;
    }

    public static void encode(EngineSliderSyncMessage mes, PacketBuffer buf) {
        buf.writeInt(mes.maxSlotSize);
        buf.writeInt(mes.upgradeStates.size());
        for (Map.Entry<Integer, Boolean> e : mes.upgradeStates.entrySet()) {
            buf.writeInt(e.getKey().intValue());
            buf.writeBoolean(e.getValue().booleanValue());
        }
    }

    public static EngineSliderSyncMessage decode(PacketBuffer buf) {
        int maxSlotSize = buf.readInt();
        int size = buf.readInt();
        HashMap<Integer, Boolean> upgradeStates = new HashMap<Integer, Boolean>();
        for (int i = 0; i < size; ++i) {
            upgradeStates.put(buf.readInt(), buf.readBoolean());
        }
        return new EngineSliderSyncMessage(maxSlotSize, upgradeStates);
    }

    public static EngineSliderSyncMessage create(int maxSlotSize, ServerWorld world) {
        Map<Integer, Boolean> map = EngineSliderSyncMessage.getUpgradeStates(maxSlotSize, (World)world);
        return new EngineSliderSyncMessage(maxSlotSize, map);
    }

    public static void handle(EngineSliderSyncMessage mes, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                Map<Integer, Boolean> map = EngineSliderSyncMessage.getUpgradeStates(mes.maxSlotSize, ((NetworkEvent.Context)context.get()).getSender().func_130014_f_());
                Network.sendTo(new EngineSliderSyncMessage(mes.maxSlotSize, map), ((NetworkEvent.Context)context.get()).getSender());
            } else {
                ClientPacketHandler.handleEngineSliderSyncClient(mes);
            }
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }

    public static Map<Integer, Boolean> getUpgradeStates(int maxSize, World world) {
        HashMap<Integer, Boolean> upgradeStates = new HashMap<Integer, Boolean>();
        world.getCapability(Capabilities.TARDIS_DATA).ifPresent(cap -> {
            for (int i = 0; i < maxSize; ++i) {
                ConsoleTile tile;
                UpgradeEntry entry;
                ItemStack stack = cap.getEngineInventoryForSide(Direction.SOUTH).getStackInSlot(i);
                if (stack == null || stack.func_190926_b() || (entry = UpgradeRegistry.getUpgradeFromItem(stack.func_77973_b())) == null || !TardisHelper.getConsoleInWorld(world).isPresent() || (tile = TardisHelper.getConsoleInWorld(world).get()) == null || !tile.getUpgrade(entry.getRegistryName()).isPresent()) continue;
                Upgrade upgrade = tile.getUpgrade(entry.getRegistryName()).get();
                upgradeStates.put(i, upgrade.isActivated());
            }
        });
        return upgradeStates;
    }
}

