/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.network.packets.console.ConsoleData;
import net.tardis.mod.network.packets.console.DataType;
import net.tardis.mod.network.packets.console.DataTypes;
import net.tardis.mod.tileentities.ConsoleTile;

public class ConsoleUpdateMessage {
    private DataType type;
    private ConsoleData data;

    public ConsoleUpdateMessage(DataType type, ConsoleData data) {
        this.type = type;
        this.data = data;
    }

    public static void encode(ConsoleUpdateMessage mes, PacketBuffer buff) {
        buff.func_180714_a(mes.type.getRegistryId());
        mes.data.serialize(buff);
    }

    public static ConsoleUpdateMessage decode(PacketBuffer buff) {
        String id = buff.func_150789_c(Short.MAX_VALUE);
        DataType type = DataTypes.CONSOLE_DATA_TYPES.get(id);
        ConsoleData data = type.getConsoleData().get();
        data.deserialize(buff);
        return new ConsoleUpdateMessage(type, data);
    }

    public static void handle(ConsoleUpdateMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> TardisHelper.getConsoleInWorld(ConsoleUpdateMessage.getWorld((NetworkEvent.Context)cont.get())).ifPresent(arg_0 -> ConsoleUpdateMessage.lambda$null$0(mes, (Supplier)cont, arg_0)));
        cont.get().setPacketHandled(true);
    }

    public static World getWorld(NetworkEvent.Context context) {
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            return context.getSender().func_71121_q();
        }
        return ClientHelper.getClientWorld();
    }

    private static /* synthetic */ void lambda$null$0(ConsoleUpdateMessage mes, Supplier cont, ConsoleTile tile) {
        mes.data.applyToConsole(tile, cont);
    }
}

