/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.Console;
import net.tardis.mod.registries.ConsoleRegistry;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.world.dimensions.TDimensions;

public class ConsoleChangeMessage {
    public ResourceLocation console;

    public ConsoleChangeMessage(ResourceLocation console) {
        this.console = console;
    }

    public static void encode(ConsoleChangeMessage mes, PacketBuffer buffer) {
        buffer.func_192572_a(mes.console);
    }

    public static ConsoleChangeMessage decode(PacketBuffer buffer) {
        return new ConsoleChangeMessage(buffer.func_192575_l());
    }

    public static void handle(ConsoleChangeMessage mes, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te;
            ServerWorld world = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q();
            if (WorldHelper.areDimensionTypesSame((World)world, TDimensions.DimensionTypes.TARDIS_TYPE) && (te = world.func_175625_s(TardisHelper.TARDIS_POS)) instanceof ConsoleTile) {
                ConsoleTile oldConsole = (ConsoleTile)te;
                Console console = (Console)ConsoleRegistry.CONSOLE_REGISTRY.get().getValue(mes.console);
                if (console != null && oldConsole.getUnlockManager().getUnlockedConsoles().contains((Object)console)) {
                    if (((ConsoleTile)te).canDoAdminFunction((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender())) {
                        CompoundNBT oldData = oldConsole.serializeNBT();
                        world.func_180501_a(oldConsole.func_174877_v(), console.getState(), 2);
                        TileEntity newConsole = world.func_175625_s(te.func_174877_v());
                        if (newConsole instanceof ConsoleTile) {
                            ((ConsoleTile)newConsole).deserializeNBT(oldData);
                            world.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> ((ConsoleTile)newConsole).updateClient()));
                        }
                    } else {
                        ((NetworkEvent.Context)ctx.get()).getSender().func_146105_b((ITextComponent)TardisConstants.Translations.NOT_ADMIN, true);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

