/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.entity.humanoid.CompanionEntity;
import net.tardis.mod.enums.EnumCompanionAction;

public class CompanionActionMessage {
    private EnumCompanionAction type;
    private UUID entityID;

    public CompanionActionMessage(UUID entityID, EnumCompanionAction type) {
        this.entityID = entityID;
        this.type = type;
    }

    public static void encode(CompanionActionMessage mes, PacketBuffer buff) {
        buff.func_179252_a(mes.entityID);
        buff.writeInt(mes.type.ordinal());
    }

    public static CompanionActionMessage decode(PacketBuffer buff) {
        UUID entityID = buff.func_179253_g();
        EnumCompanionAction type = EnumCompanionAction.values()[buff.readInt()];
        return new CompanionActionMessage(entityID, type);
    }

    public static void handle(CompanionActionMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> {
            CompanionEntity comp = (CompanionEntity)((NetworkEvent.Context)cont.get()).getSender().func_71121_q().func_217461_a(mes.entityID);
            if (comp != null && !((NetworkEvent.Context)cont.get()).getSender().field_70170_p.func_201670_d()) {
                if (mes.type == EnumCompanionAction.FLY_TARDIS) {
                    comp.setSitting(true);
                }
                if (mes.type == EnumCompanionAction.SITTING) {
                    comp.setSitting(!comp.isSitting());
                }
            }
        });
        cont.get().setPacketHandled(true);
    }
}

