/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.world.dimensions.TDimensions;

public class ChangeInteriorMessage {
    public ResourceLocation room;
    public boolean isCancelling;

    public ChangeInteriorMessage(ResourceLocation room, boolean isCancelling) {
        this.room = room;
        this.isCancelling = isCancelling;
    }

    public static void encode(ChangeInteriorMessage mes, PacketBuffer buffer) {
        buffer.func_192572_a(mes.room);
        buffer.writeBoolean(mes.isCancelling);
    }

    public static ChangeInteriorMessage decode(PacketBuffer buffer) {
        return new ChangeInteriorMessage(buffer.func_192575_l(), buffer.readBoolean());
    }

    public static void handle(ChangeInteriorMessage mes, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            TileEntity te;
            if (WorldHelper.areDimensionTypesSame(((NetworkEvent.Context)context.get()).getSender().field_70170_p, TDimensions.DimensionTypes.TARDIS_TYPE) && (te = ((NetworkEvent.Context)context.get()).getSender().field_70170_p.func_175625_s(TardisHelper.TARDIS_POS)) instanceof ConsoleTile) {
                ConsoleTile console = (ConsoleTile)te;
                if (console.getInteriorManager().canChangeInteriorAgain() || ((NetworkEvent.Context)context.get()).getSender().func_184812_l_()) {
                    ConsoleRoom room = ConsoleRoom.getRegistry().get(mes.room);
                    if (room != null) {
                        int fuelUsage = (Integer)TConfig.SERVER.interiorChangeArtronUse.get();
                        if (console.getArtron() > (float)fuelUsage) {
                            if (console.canDoAdminFunction((PlayerEntity)((NetworkEvent.Context)context.get()).getSender())) {
                                console.setupInteriorChangeProperties(room, mes.isCancelling, ((NetworkEvent.Context)context.get()).getSender().field_71075_bZ.field_75098_d);
                            } else {
                                ((NetworkEvent.Context)context.get()).getSender().func_146105_b((ITextComponent)TardisConstants.Translations.NOT_ADMIN, true);
                            }
                        } else {
                            ((NetworkEvent.Context)context.get()).getSender().func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.not_enough_artron", new Object[]{fuelUsage}), true);
                        }
                    }
                } else {
                    ((NetworkEvent.Context)context.get()).getSender().func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.interior_cooldown", new Object[]{console.getInteriorManager().getInteriorChangeTime() / 20}), true);
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

