/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.boti.BotiChunk;
import net.tardis.mod.client.ClientPacketHandler;

public class BOTIChunkMessage {
    private BotiChunk chunk;
    private int type = 0;
    private BlockPos pos = BlockPos.field_177992_a;

    public BOTIChunkMessage(BlockPos pos, BotiChunk chunk) {
        this(chunk);
        this.pos = pos;
        this.type = 1;
    }

    public BOTIChunkMessage(BotiChunk chunk) {
        this.chunk = chunk;
        this.type = 0;
    }

    public static void encode(BOTIChunkMessage mes, PacketBuffer buf) {
        buf.writeInt(mes.type);
        if (mes.type == 1) {
            buf.func_179255_a(mes.pos);
        }
        mes.chunk.encode(buf);
    }

    public static BOTIChunkMessage decode(PacketBuffer buf) {
        int type = buf.readInt();
        if (type == 1) {
            return new BOTIChunkMessage(buf.func_179259_c(), new BotiChunk(buf));
        }
        return new BOTIChunkMessage(new BotiChunk(buf));
    }

    public static void handle(BOTIChunkMessage mes, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientPacketHandler.handleBotiChunkMessage(mes.chunk, mes.pos));
        context.get().setPacketHandled(true);
    }
}

