/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import java.util.function.Supplier;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.tags.TardisItemTags;
import net.tardis.mod.tileentities.ConsoleTile;

public class ARSSpawnMessage {
    public Item key;
    private boolean useMaxStack;

    public ARSSpawnMessage(Item item, boolean useMaxStack) {
        this.key = item;
        this.useMaxStack = useMaxStack;
    }

    public static void encode(ARSSpawnMessage mes, PacketBuffer buf) {
        buf.func_192572_a(mes.key.getRegistryName());
        buf.writeBoolean(mes.useMaxStack);
    }

    public static ARSSpawnMessage decode(PacketBuffer buf) {
        return new ARSSpawnMessage((Item)ForgeRegistries.ITEMS.getValue(buf.func_192575_l()), buf.readBoolean());
    }

    public static void handle(ARSSpawnMessage mes, Supplier<NetworkEvent.Context> con) {
        con.get().enqueueWork(() -> {
            ServerWorld world = ((NetworkEvent.Context)con.get()).getSender().func_71121_q();
            if (world.func_175625_s(TardisHelper.TARDIS_POS) instanceof ConsoleTile) {
                ConsoleTile console = (ConsoleTile)world.func_175625_s(TardisHelper.TARDIS_POS);
                ItemStack stack = new ItemStack((IItemProvider)mes.key);
                if (mes.key instanceof BlockItem && mes.key.func_206844_a(TardisItemTags.ARS)) {
                    int amount;
                    int tempAmount = mes.useMaxStack ? 16 : 1;
                    int n = amount = stack.func_77976_d() > tempAmount ? tempAmount : stack.func_77976_d();
                    if (console.getArtron() >= (float)amount) {
                        console.setArtron(console.getArtron() - (float)amount);
                        InventoryHelper.func_180173_a((World)world, (double)((NetworkEvent.Context)con.get()).getSender().func_226277_ct_(), (double)((NetworkEvent.Context)con.get()).getSender().func_226278_cu_(), (double)((NetworkEvent.Context)con.get()).getSender().func_226281_cx_(), (ItemStack)new ItemStack((IItemProvider)mes.key, amount));
                    } else {
                        ((NetworkEvent.Context)con.get()).getSender().func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.not_enough_artron", new Object[]{stack.func_77976_d()}), true);
                    }
                }
            }
        });
        con.get().setPacketHandled(true);
    }
}

