/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.ars.ARSPiece;

public class ARSPieceSyncMessage {
    private Map<ResourceLocation, ARSPiece> arsPieces = new HashMap<ResourceLocation, ARSPiece>();
    public static final Codec<Map<ResourceLocation, ARSPiece>> MAPPER = Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, ARSPiece.getCodec());

    public ARSPieceSyncMessage(Map<ResourceLocation, ARSPiece> arsPieces) {
        this.arsPieces.clear();
        this.arsPieces.putAll(arsPieces);
    }

    public static void encode(ARSPieceSyncMessage mes, PacketBuffer buf) {
        buf.func_150786_a(MAPPER.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, mes.arsPieces).result().orElse(new CompoundNBT()));
    }

    public static ARSPieceSyncMessage decode(PacketBuffer buf) {
        return new ARSPieceSyncMessage(MAPPER.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)buf.func_150793_b()).result().orElse(ARSPiece.registerCoreARSPieces()));
    }

    public static void handle(ARSPieceSyncMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> ARSPiece.DATA_LOADER.setData(mes.arsPieces));
        cont.get().setPacketHandled(true);
    }
}

