/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.LandingSystem;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.registries.TardisStatistics;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.world.dimensions.TDimensions;

public class TPacketHandler {
    public static void handleVortexMTeleport(ServerPlayerEntity sender, BlockPos dest, boolean teleportPrecise) {
        TPacketHandler.handleVortexMTeleport(sender, dest, (RegistryKey<World>)sender.func_130014_f_().func_234923_W_(), false, teleportPrecise);
    }

    public static void handleVortexMTeleport(ServerPlayerEntity sender, BlockPos dest, RegistryKey<World> destWorld, boolean isInterdimensional, boolean teleportPrecise) {
        ServerWorld world = sender.func_184102_h().func_71218_a(destWorld);
        if (!LandingSystem.isPosBelowOrAboveWorld((World)world, dest.func_177956_o()) && LandingSystem.isBlockWithinWorldBorder((World)world, dest.func_177958_n(), dest.func_177956_o(), dest.func_177952_p()) && WorldHelper.canVMTravelToDimension((World)world)) {
            double diff = Math.sqrt(sender.func_233580_cy_().func_177951_i((Vector3i)dest));
            float fuelDischarge = (float)((double)((Integer)TConfig.SERVER.vmBaseFuelUsage.get()).intValue() + (Double)TConfig.SERVER.vmFuelUsageMultiplier.get() * diff);
            ItemStack vm = new ItemStack((IItemProvider)TItems.VORTEX_MANIP.get());
            ItemStack stack = PlayerHelper.getHeldOrNearestStack((PlayerEntity)sender, vm);
            stack.getCapability(Capabilities.VORTEX_MANIP).ifPresent(cap -> {
                double extraDistance;
                float fuelUsage = fuelDischarge;
                boolean shouldAddPenalty = isInterdimensional && destWorld != sender.field_70170_p.func_234923_W_();
                double d = extraDistance = shouldAddPenalty ? diff * 2.0 : 0.0;
                if (shouldAddPenalty) {
                    fuelUsage *= 1.5f;
                }
                int numSeconds = (Integer)TConfig.SERVER.vmFuelUsageTime.get();
                double yLevel = 500.0 + 0.5 * diff + extraDistance - 10.0;
                double freeFallVelocityIdealPerTick = -((Math.floor(0.98) - 1.0) * 3.92);
                double freeFallVelocityIdealSec = freeFallVelocityIdealPerTick * 20.0;
                float timeToDrain = (float)(yLevel / freeFallVelocityIdealSec) / (float)numSeconds;
                float trueFuelUsage = fuelUsage * timeToDrain;
                if (cap.getTotalCurrentCharge() >= trueFuelUsage) {
                    cap.setDischargeAmount(fuelUsage);
                    BlockPos destination = teleportPrecise ? dest : LandingSystem.getTopBlock(sender.field_70170_p, dest);
                    SpaceTimeCoord coord = new SpaceTimeCoord(destWorld, destination);
                    sender.getCapability(Capabilities.PLAYER_DATA).ifPresent(playerCap -> {
                        playerCap.setDestination(coord);
                        playerCap.calcDisplacement(sender.func_233580_cy_(), destination);
                    });
                    sender.func_71121_q().func_184133_a(null, sender.func_233580_cy_(), (SoundEvent)TSounds.VM_TELEPORT.get(), SoundCategory.BLOCKS, 0.25f, 1.0f);
                    cap.setVmUsed(true);
                    Helper.addTardisStatistic((PlayerEntity)sender, TardisStatistics.VORTEX_TRAVEL_COUNT);
                    sender.func_184102_h().func_212871_a_((Runnable)new TickDelayedTask(1, () -> WorldHelper.teleportEntities((Entity)sender, sender.field_70170_p.func_73046_m().func_71218_a(TDimensions.VORTEX_DIM), new BlockPos(0.0, yLevel, 0.0), 0.0f, 90.0f)));
                } else {
                    sender.func_146105_b((ITextComponent)TextHelper.createVortexManipMessage((IFormattableTextComponent)new TranslationTextComponent("message.vm.fuel_empty", new Object[]{Float.valueOf(trueFuelUsage)})), false);
                }
            });
        } else {
            sender.func_146105_b((ITextComponent)TextHelper.createVortexManipMessage((IFormattableTextComponent)new TranslationTextComponent("message.vm.invalidPos")), false);
        }
    }
}

