/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.missions.stages;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MissionStage
extends ForgeRegistryEntry<MissionStage>
implements INBTSerializable<CompoundNBT> {
    private int maxObjectives = 1;
    private int currentObjectiveIndex = 0;
    private String translationKey;

    public MissionStage(int maxObjectives) {
        this.maxObjectives = maxObjectives;
    }

    public MissionStage() {
        this(1);
    }

    public int getMaxObjectives() {
        return this.maxObjectives;
    }

    public MissionStage setMaxObjectives(int maxObjectives) {
        this.maxObjectives = maxObjectives;
        return this;
    }

    public int getCurrentObjectiveIndex() {
        return this.currentObjectiveIndex;
    }

    public MissionStage setObjectiveIndex(int index) {
        this.currentObjectiveIndex = index;
        return this;
    }

    public MissionStage resetObjectiveIndex() {
        return this.setObjectiveIndex(0);
    }

    public boolean isComplete() {
        return this.currentObjectiveIndex >= this.maxObjectives;
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"mission_stage", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    public TranslationTextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public IFormattableTextComponent getDisplayNameForCurrentObjective() {
        return this.getDisplayNameForObjective(this.currentObjectiveIndex);
    }

    protected IFormattableTextComponent getDisplayNameForObjective(int objective) {
        return this.getDisplayName();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("max_objectives", this.maxObjectives);
        tag.func_74768_a("current_objective", this.currentObjectiveIndex);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.maxObjectives = nbt.func_74762_e("max_objectives");
        this.currentObjectiveIndex = nbt.func_74762_e("current_objective");
    }
}

