/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.missions;

import java.util.function.BiFunction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tardis.mod.missions.MiniMission;

public class MiniMissionType
extends ForgeRegistryEntry<MiniMissionType> {
    private IMissionBuilder<MiniMission> supplier;
    private BiFunction<ServerWorld, BlockPos, BlockPos> spawner;
    private RegistryKey<StructureFeature<?, ?>> structure;

    public MiniMissionType(IMissionBuilder<MiniMission> supplier, BiFunction<ServerWorld, BlockPos, BlockPos> spawner, RegistryKey<StructureFeature<?, ?>> structure) {
        this.supplier = supplier;
        this.spawner = spawner;
        this.structure = structure;
    }

    public MiniMissionType(IMissionBuilder<MiniMission> supplier, RegistryKey<StructureFeature<?, ?>> structure) {
        this(supplier, null, structure);
    }

    public MiniMissionType(IMissionBuilder<MiniMission> supplier, BiFunction<ServerWorld, BlockPos, BlockPos> spawner) {
        this(supplier, spawner, null);
    }

    public MiniMission create(World world, BlockPos pos, int range) {
        return this.supplier.create(world, pos, range);
    }

    public BlockPos spawnMissionStage(ServerWorld world, BlockPos pos) {
        return this.spawner.apply(world, pos);
    }

    public BlockPos spawnAndFindNearestMission(ServerWorld world, StructureManager structureManager, BlockPos pos, int searchRadius, boolean skipExistingChunks, long seed, StructureSeparationSettings separationSettings) {
        return ((StructureFeature)world.func_73046_m().func_244267_aX().func_243612_b((RegistryKey)Registry.field_243553_av).func_243576_d(this.structure)).field_236268_b_.func_236388_a_((IWorldReader)world, structureManager, pos, searchRadius, skipExistingChunks, seed, separationSettings);
    }

    public RegistryKey<StructureFeature<?, ?>> getStructureKey() {
        return this.structure;
    }

    public static interface IMissionBuilder<T extends MiniMission> {
        public T create(World var1, BlockPos var2, int var3);
    }
}

