/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.missions;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.CustomServerBossInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.experimental.advancement.GenericTardisTrigger;
import net.tardis.mod.experimental.advancement.TTriggers;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.missions.MiniMissionType;
import net.tardis.mod.missions.misc.Dialog;
import net.tardis.mod.missions.misc.DialogOption;
import net.tardis.mod.missions.stages.MissionStage;
import net.tardis.mod.missions.stages.MissionStages;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.MissionUpdateMessage;

public abstract class MiniMission
implements INBTSerializable<CompoundNBT> {
    private World world;
    private BlockPos pos;
    private int range;
    private MissionStage currentStage;
    private Map<ResourceLocation, MissionStage> stages = new HashMap<ResourceLocation, MissionStage>();
    private boolean awarded = false;
    private MiniMissionType type;
    private IFormattableTextComponent barName;
    protected final IFormattableTextComponent originalBarName;
    private CustomServerBossInfo bossBar;
    private List<UUID> trackingPlayers = Lists.newArrayList();
    private List<Dialog> dialogs = Lists.newArrayList();
    private List<DialogOption> dialogOptions = Lists.newArrayList();
    private AxisAlignedBB missionBox = null;
    private GenericTardisTrigger completedAdvancementTrigger = TTriggers.DUMMY;
    private EntityType<?> hostEntity;

    public MiniMission(MiniMissionType type, World world, BlockPos pos, int range) {
        this.world = world;
        this.pos = pos;
        this.range = range;
        this.type = type;
        this.barName = this.originalBarName = new TranslationTextComponent(Util.func_200697_a((String)"missions", (ResourceLocation)type.getRegistryName()));
        this.bossBar = new CustomServerBossInfo(Helper.createRL("mini_mission"), (ITextComponent)this.getMissionName());
        this.bossBar.func_186745_a(BossInfo.Color.WHITE);
        this.bossBar.func_186746_a(BossInfo.Overlay.PROGRESS);
        this.bossBar.func_186735_a(0.0f);
        this.hostEntity = (EntityType)TEntities.SHIP_CAPTAIN.get();
        this.registerStages();
    }

    public MiniMission(MiniMissionType type, World world, CompoundNBT tag) {
        this(type, world, BlockPos.field_177992_a, 0);
        this.deserializeNBT(tag);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74772_a("pos", this.pos.func_218275_a());
        tag.func_74768_a("range", this.range);
        tag.func_74778_a("current_stage", this.currentStage.getRegistryName().toString());
        tag.func_74757_a("awarded", this.awarded);
        ListNBT stages = new ListNBT();
        for (Map.Entry<ResourceLocation, MissionStage> stage : this.stages.entrySet()) {
            CompoundNBT stageTag = stage.getValue().serializeNBT();
            stages.add((Object)stageTag);
        }
        tag.func_218657_a("stages", (INBT)stages);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.pos = BlockPos.func_218283_e((long)tag.func_74763_f("pos"));
        this.range = tag.func_74762_e("range");
        this.awarded = tag.func_74767_n("awarded");
        ListNBT stages = tag.func_150295_c("stages", 10);
        for (INBT nbt : stages) {
            CompoundNBT comp = (CompoundNBT)nbt;
            MissionStage stage = new MissionStage();
            stage.deserializeNBT(comp);
            if (stage == null) continue;
            this.stages.put(stage.getRegistryName(), stage);
        }
        this.currentStage = this.stages.get(new ResourceLocation(tag.func_74779_i("current_stage")));
    }

    public void registerStages() {
        this.registerStage((MissionStage)MissionStages.NOT_STARTED.get());
        this.registerStage((MissionStage)MissionStages.RETURN_TO_MISSION_HOST.get());
        this.registerStage((MissionStage)MissionStages.MISSION_COMPLETED.get());
    }

    public void registerStage(MissionStage stage) {
        this.stages.put(stage.getRegistryName(), stage);
    }

    public int getCurrentObjective() {
        return this.currentStage.getCurrentObjectiveIndex();
    }

    public void setObjective(int objective) {
        this.setObjectiveForStage(this.currentStage.getRegistryName(), objective);
    }

    public void setObjectiveForStage(ResourceLocation stageKey, int objective) {
        MissionStage stage = this.stages.get(stageKey);
        stage.setObjectiveIndex(objective);
        if (stage.isComplete()) {
            this.setCurrentStage(this.getNextStage().resetObjectiveIndex());
        }
        if (this.bossBar != null) {
            this.getBossBar().func_186735_a(this.getProgressBarPercent());
        }
        this.update();
    }

    public void advanceObjective() {
        this.setObjective(this.currentStage.getCurrentObjectiveIndex() + 1);
    }

    public int getMaxObjectivesForCurrentStage() {
        return this.currentStage.getMaxObjectives();
    }

    public int getMaxObjectivesForStage(ResourceLocation stageID) {
        return this.stages.get(stageID).getMaxObjectives();
    }

    public int getTotalObjectives() {
        int max = 0;
        for (MissionStage stage : this.stages.values()) {
            max += stage.getMaxObjectives();
        }
        return max;
    }

    public MissionStage getCurrentStage() {
        return this.currentStage;
    }

    public void setCurrentStage(MissionStage stage) {
        this.currentStage = stage;
        this.update();
    }

    public abstract MissionStage getNextStage();

    public Map<ResourceLocation, MissionStage> getStages() {
        return this.stages;
    }

    public MissionStage getStageByKey(ResourceLocation id) {
        return this.stages.get(id);
    }

    public int getTotalNumStages() {
        return this.stages.size();
    }

    public int getNumStagesCompleted() {
        int numStagesComplete = 0;
        for (MissionStage stage : this.stages.values()) {
            if (!stage.isComplete()) continue;
            ++numStagesComplete;
        }
        return numStagesComplete;
    }

    public int getMaxStage() {
        return this.stages.size();
    }

    public abstract float getProgressBarPercent();

    public abstract Dialog getDialogForObjective(LivingEntity var1, PlayerEntity var2, int var3);

    public boolean isMissionComplete() {
        return this.getNumStagesCompleted() == this.stages.size() - 1;
    }

    public IFormattableTextComponent getMissionName() {
        return this.barName;
    }

    public void setMissionName(IFormattableTextComponent newName) {
        this.barName = newName;
        this.bossBar.func_186739_a((ITextComponent)this.barName);
    }

    public int getRange() {
        return this.range;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public World getWorld() {
        return this.world;
    }

    public abstract ItemStack getReward();

    public boolean getAwarded() {
        return this.awarded;
    }

    public void setAwarded(boolean awarded) {
        this.awarded = awarded;
        this.update();
    }

    public void onPlayerEnterMissionArea(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            this.bossBar.func_186760_a((ServerPlayerEntity)player);
        }
    }

    public void onPlayerLeaveMissionArea(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            this.bossBar.func_186761_b((ServerPlayerEntity)player);
        }
    }

    public MiniMissionType getType() {
        return this.type;
    }

    public ServerBossInfo getBossBar() {
        return this.bossBar;
    }

    public void setBossBarColour(BossInfo.Color color) {
        this.bossBar.func_186745_a(color);
    }

    public void setBossBarStyle(BossInfo.Overlay styleType) {
        this.bossBar.func_186746_a(styleType);
    }

    public boolean isInsideArea(Entity ent) {
        if (this.world.func_234923_W_() != ent.field_70170_p.func_234923_W_()) {
            return false;
        }
        return this.pos.func_218141_a((Vector3i)ent.func_233580_cy_(), (double)this.range);
    }

    public List<UUID> getTrackingPlayers() {
        return Collections.unmodifiableList(this.trackingPlayers);
    }

    public void addTrackingPlayer(ServerPlayerEntity player) {
        if (!this.trackingPlayers.contains(player.func_110124_au())) {
            this.trackingPlayers.add(player.func_110124_au());
            this.bossBar.func_186760_a(player);
        }
    }

    public void removeTrackingPlayer(ServerPlayerEntity player) {
        if (this.trackingPlayers.contains(player.func_110124_au())) {
            this.trackingPlayers.remove(player.func_110124_au());
            this.bossBar.func_186761_b(player);
        }
    }

    public AxisAlignedBB getMissionBB() {
        if (this.missionBox == null) {
            this.missionBox = new AxisAlignedBB(this.pos).func_186662_g((double)this.range);
        }
        return this.missionBox;
    }

    public GenericTardisTrigger getCompletedAdvancementTrigger() {
        return this.completedAdvancementTrigger;
    }

    public EntityType<?> getMissionHostEntity() {
        return this.hostEntity;
    }

    public void update() {
        if (!this.world.field_72995_K) {
            Network.sendToAllInWorld(new MissionUpdateMessage(this), (ServerWorld)this.world);
        }
    }

    public Dialog createDialogForCharacter(String translationSuffixKey) {
        Dialog dialog = new Dialog(this.createDialogTranslationKey(translationSuffixKey));
        this.dialogs.add(dialog);
        return dialog;
    }

    public String createDialogTranslationKey(String translationSuffixKey) {
        return "mission.tardis." + this.getType().getRegistryName().func_110623_a().toString() + ".dialog.character." + translationSuffixKey;
    }

    public TranslationTextComponent createDialogTranslationKey(String modId, String translationSuffixKey) {
        return new TranslationTextComponent("mission." + modId + "." + this.getType().getRegistryName().func_110623_a().toString() + ".dialog.character." + translationSuffixKey);
    }

    public DialogOption createPlayerResponse(@Nullable Dialog dialog, TranslationTextComponent responseKey) {
        return new DialogOption(dialog, responseKey);
    }

    public DialogOption createPlayerResponse(@Nullable Dialog nextDialog, String responseKey) {
        DialogOption dialogOption = new DialogOption(nextDialog, new TranslationTextComponent(this.createPlayerResponseTranslationKey(responseKey)));
        this.dialogOptions.add(dialogOption);
        return dialogOption;
    }

    public DialogOption createPlayerResponseWithArguments(@Nullable Dialog nextDialog, String responseKey, String args) {
        DialogOption dialogOption = new DialogOption(nextDialog, new TranslationTextComponent(this.createPlayerResponseTranslationKey(responseKey), new Object[]{args}));
        this.dialogOptions.add(dialogOption);
        return dialogOption;
    }

    public String createPlayerResponseTranslationKey(String translationSuffixKey) {
        return "mission.tardis." + this.getType().getRegistryName().func_110623_a().toString() + ".dialog_option.player." + translationSuffixKey;
    }

    public String createDialogOptionTranslationKey(String translationSuffixKey) {
        return "mission.tardis." + this.getType().getRegistryName().func_110623_a().toString() + ".dialog_option.player" + translationSuffixKey;
    }

    public TranslationTextComponent createDialogOptionTranslationKey(String modId, String translationSuffixKey) {
        return new TranslationTextComponent("mission." + modId + "." + this.getType().getRegistryName().func_110623_a().toString() + ".dialog_option.player" + translationSuffixKey);
    }
}

