/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.missions;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.tardis.mod.missions.MiniMissionType;
import net.tardis.mod.missions.TickableMission;
import net.tardis.mod.missions.stages.MissionStage;
import net.tardis.mod.missions.stages.MissionStages;

public abstract class KillMission
extends TickableMission {
    public KillMission(MiniMissionType type, World world, BlockPos pos, int range) {
        super(type, world, pos, range);
        this.setBossBarColour(BossInfo.Color.RED);
        this.setCurrentStage((MissionStage)MissionStages.NOT_STARTED.get());
    }

    public void onKill(Entity entity) {
        if (!entity.field_70170_p.field_72995_K && entity.func_200600_R() == this.getKillTargetEntityType() && this.shouldKillAdvance()) {
            this.advanceObjective();
        }
    }

    public int getValidEntitiesInArea() {
        List entities = this.getWorld().func_217357_a(Entity.class, this.getMissionBB());
        entities.removeIf(ent -> ent.func_200600_R() != this.getKillTargetEntityType());
        return entities.size();
    }

    public abstract EntityType<?> getKillTargetEntityType();

    public abstract boolean shouldKillAdvance();

    public abstract boolean shouldSpawnMore();

    public abstract boolean canKillTargetEntitySpawnHere(World var1, BlockPos var2);

    public void onSpawnEntity(Entity ent) {
    }

    @Override
    public void tick(World world) {
        super.tick(world);
        if (!world.func_201670_d() && this.shouldSpawnMore()) {
            block0: for (PlayerEntity player : world.func_217357_a(PlayerEntity.class, this.getMissionBB())) {
                for (int i = 0; i < 64; ++i) {
                    BlockPos pos = this.getValidSpawnPos(world, player);
                    if (pos.equals((Object)BlockPos.field_177992_a) || !this.canKillTargetEntitySpawnHere(this.getWorld(), pos)) continue;
                    if (!this.shouldSpawnMore()) continue block0;
                    Entity ent = this.getKillTargetEntityType().func_200721_a(world);
                    ent.func_70107_b((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5);
                    this.onSpawnEntity(ent);
                    world.func_217376_c(ent);
                    continue block0;
                }
            }
        }
    }

    private BlockPos getValidSpawnPos(World world, PlayerEntity player) {
        int z;
        int y;
        int minRad = 10;
        int maxRad = 30;
        int x = (int)player.func_226277_ct_() + minRad + player.func_70681_au().nextInt(maxRad - minRad);
        BlockPos pos = new BlockPos(x, y = (int)player.func_226278_cu_(), z = (int)player.func_226281_cx_() + minRad + player.func_70681_au().nextInt(maxRad - minRad));
        if (world.func_180495_p(pos).func_196958_f()) {
            for (int ny = y - minRad; ny < world.func_217301_I(); ++ny) {
                if (!world.func_180495_p(new BlockPos(x, ny, z)).func_200132_m()) continue;
                return pos;
            }
            return pos;
        }
        return BlockPos.field_177992_a;
    }

    @Override
    public void registerStages() {
        super.registerStages();
        this.registerStage((MissionStage)MissionStages.KILL_DRONES.get());
    }
}

