/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.missions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;
import net.tardis.api.space.IOxygenSealer;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.humanoid.CrewmateEntity;
import net.tardis.mod.entity.humanoid.HumanoidEmotionalState;
import net.tardis.mod.entity.humanoid.ShipCaptainEntity;
import net.tardis.mod.entity.mission.HumanoidMissionEntity;
import net.tardis.mod.experimental.advancement.GenericTardisTrigger;
import net.tardis.mod.experimental.advancement.TTriggers;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.loottables.TardisLootTables;
import net.tardis.mod.missions.KillMission;
import net.tardis.mod.missions.MiniMission;
import net.tardis.mod.missions.MiniMissionType;
import net.tardis.mod.missions.misc.Dialog;
import net.tardis.mod.missions.misc.DialogOption;
import net.tardis.mod.missions.stages.MissionStage;
import net.tardis.mod.missions.stages.MissionStages;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.CompleteMissionMessage;
import net.tardis.mod.network.packets.MissionUpdateMessage;
import net.tardis.mod.network.packets.SetMissionObjectiveMessage;
import net.tardis.mod.registries.MissionRegistry;
import net.tardis.mod.tileentities.ShipComputerTile;
import net.tardis.mod.world.dimensions.TDimensions;

public class DroneStationMission
extends KillMission {
    public DroneStationMission(World world, BlockPos pos, int range) {
        super((MiniMissionType)MissionRegistry.STATION_DRONE.get(), world, pos, range);
    }

    @Override
    public ItemStack getReward() {
        return new ItemStack((IItemProvider)TItems.TELE_STRUCTURE_UPGRADE.get());
    }

    @Override
    public EntityType<?> getKillTargetEntityType() {
        return (EntityType)TEntities.SECURITY_DROID.get();
    }

    @Override
    public float getProgressBarPercent() {
        return (float)this.getCurrentObjective() / (float)this.getMaxObjectivesForCurrentStage();
    }

    @Override
    public boolean shouldKillAdvance() {
        return this.getCurrentStage() == MissionStages.KILL_DRONES.get() && !this.getCurrentStage().isComplete();
    }

    @Override
    public boolean shouldSpawnMore() {
        return this.getCurrentStage() == MissionStages.KILL_DRONES.get() && !this.getCurrentStage().isComplete() && this.getValidEntitiesInArea() < 8;
    }

    @Override
    public Dialog getDialogForObjective(LivingEntity speaker, PlayerEntity player, int stage) {
        if (this.getCurrentStage() == MissionStages.NOT_STARTED.get()) {
            HumanoidMissionEntity missionHumanoid;
            Dialog root = this.createDialogForCharacter("capt.confused_greet");
            DialogOption smartass = this.createPlayerResponse(null, "smartass");
            Dialog helpResp = this.createDialogForCharacter("capt.relieved_request");
            helpResp.addDialogOption(this.createPlayerResponse(null, "understand_request"));
            DialogOption helping = this.createPlayerResponseWithArguments(helpResp, "respond_sos_with_intro", player.func_145748_c_().getString());
            helping.setOptionAction((speak, player2) -> Network.sendToServer(new SetMissionObjectiveMessage(speak.func_233580_cy_(), 1, this.getCurrentStage().getRegistryName())));
            root.addDialogOption(smartass);
            root.addDialogOption(helping);
            Dialog hostileGreet = this.createDialogForCharacter("capt.hostile_greet");
            Dialog frustratedResp = this.createDialogForCharacter("capt.frustrated_request");
            DialogOption respondSosPacify = this.createPlayerResponse(frustratedResp, "agree_to_help");
            respondSosPacify.setOptionAction((speak, player1) -> Network.sendToServer(new SetMissionObjectiveMessage(speak.func_233580_cy_(), 1, this.getCurrentStage().getRegistryName())));
            frustratedResp.addDialogOption(this.createPlayerResponse(null, "ignore_frustrated_request"));
            frustratedResp.addDialogOption(respondSosPacify);
            hostileGreet.addDialogOption(this.createPlayerResponse(frustratedResp, "respond_sos_pacifying"));
            hostileGreet.addDialogOption(smartass);
            if (speaker instanceof HumanoidMissionEntity && (missionHumanoid = (HumanoidMissionEntity)speaker).getEmotionalState() == HumanoidEmotionalState.HOSTILE) {
                return hostileGreet;
            }
            return root;
        }
        if (this.getCurrentStage() == MissionStages.KILL_DRONES.get()) {
            if (this.getCurrentObjective() == 0) {
                Dialog root = this.createDialogForCharacter("capt.followup_player");
                DialogOption.DialogAction action = (speak, play) -> speak.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197609_b, speak.func_226277_ct_(), (double)speak.func_70047_e() + 1.0, speak.func_226281_cx_(), 0.0, 0.05, 0.0);
                root.addDialogOption(this.createPlayerResponse(null, "followup_polite"));
                root.addDialogOption(this.createPlayerResponse(null, "followup_rude").setOptionAction(action));
                root.addDialogOption(this.createPlayerResponse(null, "followup_frustrated").setOptionAction(action));
                return root;
            }
            if (this.getCurrentObjective() > 0 && !this.getCurrentStage().isComplete()) {
                Dialog moreDrones = this.createDialogForCharacter("capt.followup_player.more_drones");
                DialogOption.DialogAction action = (speak, play) -> speak.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197609_b, speak.func_226277_ct_(), (double)speak.func_70047_e() + 1.0, speak.func_226281_cx_(), 0.0, 0.05, 0.0);
                moreDrones.addDialogOption(this.createPlayerResponse(null, "acknowledge_polite"));
                moreDrones.addDialogOption(this.createPlayerResponse(null, "acknowledge_rude").setOptionAction(action));
                moreDrones.addDialogOption(this.createPlayerResponse(null, "acknowledge_frustrated").setOptionAction(action));
                return moreDrones;
            }
        } else if (this.getCurrentStage() == MissionStages.RETURN_TO_MISSION_HOST.get() && !this.getAwarded()) {
            DialogOption.DialogAction spawnReward = (speak, player1) -> {
                Network.sendToServer(new SetMissionObjectiveMessage(speaker.func_233580_cy_(), 1, this.getCurrentStage().getRegistryName()));
                Network.sendToServer(new CompleteMissionMessage(speaker.func_233580_cy_()));
            };
            Dialog dia = this.createDialogForCharacter("capt.thankful_reward");
            DialogOption accept = this.createPlayerResponse(null, "polite_accept_reward");
            accept.setOptionAction(spawnReward);
            DialogOption acceptRude = this.createPlayerResponse(null, "ungrateful_accept_reward");
            acceptRude.setOptionAction(spawnReward);
            dia.addDialogOption(accept);
            dia.addDialogOption(acceptRude);
            return dia;
        }
        return null;
    }

    @Deprecated
    public static BlockPos setupMission(ServerWorld world, BlockPos start) {
        if (!WorldHelper.areDimensionTypesSame((World)world, TDimensions.DimensionTypes.SPACE_TYPE)) {
            return BlockPos.field_177992_a;
        }
        int radius = 5000;
        BlockPos test = new BlockPos(start.func_177958_n() + (-radius + world.func_201674_k().nextInt(radius)), 0, start.func_177958_n() + (-radius + world.func_201674_k().nextInt(radius)));
        if (!world.func_175723_af().func_177746_a(test) || !world.func_175723_af().func_177746_a(test.func_177982_a(128, 0, 128))) {
            return BlockPos.field_177992_a;
        }
        ChunkPos cPos = new ChunkPos(test);
        if (!world.func_217354_b(cPos.field_77276_a, cPos.field_77275_b)) {
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    world.func_217458_b(cPos.field_77276_a + x, cPos.field_77275_b + z, true);
                }
            }
            ArrayList landingSpots = Lists.newArrayList();
            test = test.func_177963_a(0.0, 64.0 + world.field_73012_v.nextDouble() * 64.0, 0.0);
            PlacementSettings settings = new PlacementSettings();
            Template temp = world.func_184163_y().func_200219_b(Helper.createRL("tardis/structures/worldgen/space/spacestation_drone"));
            temp.func_237144_a_((IServerWorld)world, test, new PlacementSettings(), world.field_73012_v);
            for (Template.BlockInfo info : temp.func_215381_a(test, settings, Blocks.field_185779_df)) {
                if (info.field_186244_c != null && info.field_186244_c.func_74764_b("metadata")) {
                    String data = info.field_186244_c.func_74779_i("metadata");
                    if (data.contentEquals("captain_spawn")) {
                        BlockPos entCap = info.field_186242_a.func_185334_h();
                        ShipCaptainEntity cap = (ShipCaptainEntity)((EntityType)TEntities.SHIP_CAPTAIN.get()).func_200721_a((World)world);
                        cap.func_70107_b((double)entCap.func_177958_n() + 0.5, entCap.func_177956_o() + 1, (double)entCap.func_177952_p() + 0.5);
                        cap.func_213386_a((IServerWorld)world.func_201672_e(), world.func_175649_E(entCap), SpawnReason.STRUCTURE, null, null);
                        world.func_217376_c((Entity)cap);
                    } else if (data.contentEquals("mission_marker")) {
                        world.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(0, () -> world.getCapability(Capabilities.MISSION).ifPresent(missions -> {
                            MiniMission mis = ((MiniMissionType)MissionRegistry.STATION_DRONE.get()).create((World)world, info.field_186242_a, 64);
                            missions.addMission(mis);
                            Network.sendToAllInWorld(new MissionUpdateMessage(mis), world);
                        })));
                    } else if (data.contentEquals("crewmates")) {
                        int num = 2 + world.func_201674_k().nextInt(3);
                        for (int i = 0; i < num; ++i) {
                            CrewmateEntity entity = (CrewmateEntity)((EntityType)TEntities.CREWMATE.get()).func_200721_a((World)world);
                            entity.func_70107_b((double)info.field_186242_a.func_177958_n() + 0.5, info.field_186242_a.func_177956_o() + 1, (double)info.field_186242_a.func_177952_p() + 0.5);
                            entity.func_213386_a((IServerWorld)world.func_201672_e(), world.func_175649_E(info.field_186242_a), SpawnReason.STRUCTURE, null, null);
                            world.func_217376_c((Entity)entity);
                        }
                    }
                }
                world.func_180501_a(info.field_186242_a, Blocks.field_150350_a.func_176223_P(), 3);
            }
            for (Template.BlockInfo info : temp.func_215381_a(test, settings, (Block)TBlocks.ship_computer.get())) {
                ShipComputerTile tile = (ShipComputerTile)world.func_175625_s(info.field_186242_a);
                tile.setLootTable(TardisLootTables.SPACESTATION_DRONE);
            }
            for (Template.BlockInfo info : temp.func_215381_a(test, settings, (Block)TBlocks.landing_pad.get())) {
                landingSpots.add(info.field_186242_a);
            }
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    world.func_217458_b(cPos.field_77276_a + x, cPos.field_77275_b + z, false);
                }
            }
            return landingSpots.size() > 0 ? (BlockPos)landingSpots.get(world.field_73012_v.nextInt(landingSpots.size())) : test.func_185334_h();
        }
        return BlockPos.field_177992_a;
    }

    @Override
    public boolean canKillTargetEntitySpawnHere(World world, BlockPos pos) {
        List<TileEntity> tes = WorldHelper.getTEsInChunks((ServerWorld)world, new ChunkPos(pos), 3);
        for (TileEntity te : tes) {
            IOxygenSealer sealer = (IOxygenSealer)te.getCapability(Capabilities.OXYGEN_SEALER).orElse(null);
            if (sealer == null || !sealer.getSealedPositions().contains(pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GenericTardisTrigger getCompletedAdvancementTrigger() {
        return TTriggers.DRONE_MISSION_COMPLETE;
    }

    @Override
    public MissionStage getNextStage() {
        if (this.getCurrentStage() == MissionStages.NOT_STARTED.get() && this.getCurrentStage().isComplete()) {
            return (MissionStage)MissionStages.KILL_DRONES.get();
        }
        if (this.getCurrentStage() == MissionStages.KILL_DRONES.get() && this.getCurrentStage().isComplete()) {
            return (MissionStage)MissionStages.RETURN_TO_MISSION_HOST.get();
        }
        if (this.getCurrentStage() == MissionStages.RETURN_TO_MISSION_HOST.get() && this.getCurrentStage().isComplete()) {
            return (MissionStage)MissionStages.MISSION_COMPLETED.get();
        }
        return this.getCurrentStage();
    }
}

