/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class WorldText {
    public float width;
    public float height;
    public float scale;
    private int color = 0xFFFFFF;
    private boolean dropShadow = false;

    public WorldText(float width, float height, float scale, int color) {
        this.width = width;
        this.height = height;
        this.color = color;
        this.scale = scale;
    }

    public WorldText(float width, float height, float scale, TextFormatting color) {
        this(width, height, scale, color.func_211163_e());
    }

    public void setDropShadow(boolean shadow) {
        this.dropShadow = shadow;
    }

    public void renderText(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, boolean showRenderBounds, String ... lines) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        float offsetY = 0.0f;
        for (int i = 0; i < lines.length; ++i) {
            IReorderingProcessor processor = IReorderingProcessor.func_242239_a((String)lines[i], (Style)Style.field_240709_b_);
            matrixStack.func_227860_a_();
            float scale = this.getScale(fr, lines[i]);
            matrixStack.func_227861_a_(0.0, (double)offsetY, 0.0);
            matrixStack.func_227862_a_(scale, scale, scale);
            fr.func_238416_a_(processor, 0.0f, 0.0f, this.color, this.dropShadow, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLight);
            matrixStack.func_227865_b_();
            fr.getClass();
            offsetY += this.scale * (float)(9 + 1);
        }
        if (showRenderBounds) {
            this.showRenderBounds(matrixStack, buffer.getBuffer(RenderType.func_228659_m_()));
        }
    }

    public void renderText(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, String ... lines) {
        this.renderText(matrixStack, buffer, combinedLight, false, lines);
    }

    public void renderText(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, List<String> lines) {
        String[] allLines = new String[lines.size()];
        lines.toArray(allLines);
        this.renderText(matrixStack, buffer, combinedLight, allLines);
    }

    public float getScale(FontRenderer fr, String line) {
        int lineWidth = fr.func_78256_a(line);
        float scale = this.width / (float)lineWidth;
        scale = MathHelper.func_76131_a((float)scale, (float)0.0f, (float)this.scale);
        return scale;
    }

    private void showRenderBounds(MatrixStack matrixStack, IVertexBuilder builder) {
        RenderSystem.disableTexture();
        MatrixStack.Entry matrixstackEntry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = matrixstackEntry.func_227870_a_();
        builder.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, this.width, 0.0f, 0.0f).func_227885_a_(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, 0.0f, this.height, 0.0f).func_227885_a_(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, this.width, this.height, 0.0f).func_227885_a_(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.0f).func_227885_a_(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, 0.0f, this.height, 0.0f).func_227885_a_(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, this.width, 0.0f, 0.0f).func_227885_a_(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, this.width, this.height, 0.0f).func_227885_a_(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        RenderSystem.enableTexture();
    }
}

