/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.Tardis;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.misc.IngredientCodec;
import net.tardis.mod.misc.PrepopulatedCodecListener;
import org.apache.logging.log4j.Level;

public class TardisLike {
    private static final Codec<TardisLike> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCodec.INGREDIENT_CODEC.listOf().fieldOf("ingredient").forGetter(TardisLike::getItem), (App)Codec.INT.fieldOf("loyalty_weight").forGetter(TardisLike::getLoyaltyMod)).apply((Applicative)instance, TardisLike::new));
    public static final PrepopulatedCodecListener<TardisLike> DATA_LOADER = new PrepopulatedCodecListener<TardisLike>("tardis_likes", CODEC, Tardis.LOGGER, () -> TardisLike.registerCoreEntries());
    private int loyaltyMod = 0;
    private List<Ingredient> ingredients;

    public TardisLike(List<Ingredient> items, int amount) {
        this.loyaltyMod = amount;
        this.ingredients = items;
    }

    public List<Ingredient> getItem() {
        return this.ingredients;
    }

    public int getLoyaltyMod() {
        return this.loyaltyMod;
    }

    public boolean matches(ItemStack stack) {
        boolean stackInIngredient = false;
        for (Ingredient ing : this.ingredients) {
            if (!ing.test(stack)) continue;
            stackInIngredient = true;
            break;
        }
        return stackInIngredient;
    }

    private static TardisLike register(Ingredient ingredient, int loyaltyMod, String key) {
        return TardisLike.register(ingredient, loyaltyMod, Helper.createRL(key));
    }

    public static TardisLike register(Ingredient ingredient, int loyaltyMod, ResourceLocation registryName) {
        TardisLike like = new TardisLike(Lists.newArrayList((Object[])new Ingredient[]{ingredient}), loyaltyMod);
        DATA_LOADER.getData().put(registryName, like);
        if (registryName == null) {
            throw new NullPointerException();
        }
        return like;
    }

    public static Codec<TardisLike> getCodec() {
        return CODEC;
    }

    public static Map<ResourceLocation, TardisLike> registerCoreEntries() {
        DATA_LOADER.getData().clear();
        Tardis.LOGGER.log(Level.INFO, "Cleared Tardis Like Registry!");
        TardisLike.register(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151111_aL}), 5, "compass");
        TardisLike.register(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151098_aY}), 10, "filled_map");
        TardisLike.register(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151079_bi}), 15, "ender_pearl");
        TardisLike.register(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151113_aN}), 20, "clock");
        TardisLike.register(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151061_bv}), 20, "ender_eye");
        TardisLike.register(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222109_pP}), 25, "bell");
        Tardis.LOGGER.log(Level.INFO, "Registered default Tardis Likes");
        return DATA_LOADER.getData();
    }

    public static Collection<TardisLike> getValues() {
        return DATA_LOADER.getData().values();
    }
}

