/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.tardis.mod.helper.WorldHelper;

public class SpaceTimeCoord {
    public static final SpaceTimeCoord UNIVERAL_CENTER = new SpaceTimeCoord((RegistryKey<World>)World.field_234918_g_, BlockPos.field_177992_a, Direction.NORTH);
    private BlockPos pos;
    private ResourceLocation dimRL;
    private Direction facing;
    private String name = "";

    public SpaceTimeCoord(RegistryKey<World> world, BlockPos pos, Direction dir) {
        this(world.func_240901_a_(), pos, dir);
    }

    public SpaceTimeCoord(ResourceLocation dimRL, BlockPos pos, Direction dir) {
        this.dimRL = dimRL;
        this.pos = pos;
        this.facing = dir;
    }

    public SpaceTimeCoord(RegistryKey<World> world, BlockPos pos) {
        this(world, pos, Direction.NORTH);
    }

    public static SpaceTimeCoord deserialize(CompoundNBT tag) {
        SpaceTimeCoord coord = new SpaceTimeCoord(new ResourceLocation(tag.func_74779_i("dim")), BlockPos.func_218283_e((long)tag.func_74763_f("pos")), Direction.values()[tag.func_74762_e("dir")]);
        if (tag.func_74764_b("name")) {
            coord.setName(tag.func_74779_i("name"));
        }
        return coord;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ResourceLocation getDimRL() {
        return this.dimRL;
    }

    public RegistryKey<World> getDim() {
        return WorldHelper.getWorldKeyFromRL(this.dimRL);
    }

    public Direction getFacing() {
        return this.facing;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74772_a("pos", this.pos.func_218275_a());
        tag.func_74778_a("dim", this.dimRL.toString());
        tag.func_74768_a("dir", this.facing.ordinal());
        tag.func_74778_a("name", this.name);
        return tag;
    }

    public SpaceTimeCoord toImmutable() {
        SpaceTimeCoord coord = new SpaceTimeCoord((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)this.dimRL), this.pos);
        if (this.name != null) {
            coord.setName(this.name);
        }
        return coord;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpaceTimeCoord)) {
            return false;
        }
        SpaceTimeCoord other = (SpaceTimeCoord)obj;
        return this.pos.equals((Object)other.pos) && this.dimRL.equals((Object)other.dimRL);
    }
}

