/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.misc.CodecJsonDataListener;
import org.apache.logging.log4j.Logger;

public class PrepopulatedCodecListener<T>
extends CodecJsonDataListener<T> {
    private Supplier<Map<ResourceLocation, T>> initialValues;

    public PrepopulatedCodecListener(String folderName, Codec<T> codec, Logger logger, Supplier<Map<ResourceLocation, T>> initialValues) {
        super(folderName, codec, logger);
        this.initialValues = initialValues;
    }

    @Override
    public Map<ResourceLocation, T> mapValues(Map<ResourceLocation, JsonElement> inputs) {
        Map<ResourceLocation, T> map = this.initialValues.get();
        HashMap parsedInData = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : inputs.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> {
                parsedInData.put(key, result.getFirst());
                this.logger.info("Added Datapack entry: {}", (Object)key.toString());
            }).ifRight(partial -> this.logger.error("Failed to parse data json for {} due to: {}", (Object)key.toString(), (Object)partial.message()));
        }
        map.putAll(parsedInData);
        return map;
    }
}

