/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class Partition<T>
extends AbstractList<List<T>> {
    private final List<T> list;
    private final int chunkSize;

    public Partition(List<T> list, int chunkSize) {
        this.list = new ArrayList<T>(list);
        this.chunkSize = chunkSize;
    }

    public static <T> Partition<T> ofSize(List<T> list, int chunkSize) {
        return new Partition<T>(list, chunkSize);
    }

    @Override
    public List<T> get(int index) {
        int start = index * this.chunkSize;
        int end = Math.min(start + this.chunkSize, this.list.size());
        if (start > end) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of the list range < 0," + (this.size() - 1) + ">");
        }
        return new ArrayList<T>(this.list.subList(start, end));
    }

    @Override
    public int size() {
        return (int)Math.ceil((double)this.list.size() / (double)this.chunkSize);
    }
}

