/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;

public class MergeableCodecJsonDataListener<RAW, FINE>
extends ReloadListener<Map<ResourceLocation, FINE>> {
    protected static final String JSON_EXTENSION = ".json";
    protected static final int JSON_EXTENSION_LENGTH = ".json".length();
    protected static final Gson STANDARD_GSON = new Gson();
    private final String folderName;
    private final Logger logger;
    private final Codec<RAW> codec;
    private final Function<List<RAW>, FINE> merger;
    private final Gson gson;
    private Optional<Runnable> syncDataOnReload = Optional.empty();
    @Nonnull
    public Map<ResourceLocation, FINE> data = new HashMap<ResourceLocation, FINE>();

    public MergeableCodecJsonDataListener(String folderName, Logger logger, Codec<RAW> codec, Function<List<RAW>, FINE> merger, Gson gson) {
        this.folderName = folderName;
        this.logger = logger;
        this.codec = codec;
        this.merger = merger;
        this.gson = gson;
    }

    public MergeableCodecJsonDataListener(String folderName, Logger logger, Codec<RAW> codec, Function<List<RAW>, FINE> merger) {
        this(folderName, logger, codec, merger, STANDARD_GSON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<ResourceLocation, FINE> prepare(IResourceManager resourceManager, IProfiler profiler) {
        HashMap map = Maps.newHashMap();
        for (ResourceLocation resourceLocation : resourceManager.func_199003_a(this.folderName, MergeableCodecJsonDataListener::isStringJsonFile)) {
            String namespace = resourceLocation.func_110624_b();
            String filePath = resourceLocation.func_110623_a();
            String dataPath = filePath.substring(this.folderName.length() + 1, filePath.length() - JSON_EXTENSION_LENGTH);
            ResourceLocation jsonObjectID = new ResourceLocation(namespace, dataPath);
            ArrayList unmergedRaws = new ArrayList();
            try {
                for (IResource resource : resourceManager.func_199004_b(resourceLocation)) {
                    try (InputStream inputstream = resource.func_199027_b();
                         BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                        JsonElement jsonElement = (JsonElement)JSONUtils.func_193839_a((Gson)this.gson, (Reader)reader, JsonElement.class);
                        this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).resultOrPartial(MergeableCodecJsonDataListener::throwJsonParseException).ifPresent(unmergedRaws::add);
                    }
                    catch (IOException | RuntimeException exception) {
                        this.logger.error("Data loader for {} could not read data {} from file {} in data pack {}", (Object)this.folderName, (Object)jsonObjectID, (Object)resourceLocation, (Object)resource.func_199026_d(), (Object)exception);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                    map.put(jsonObjectID, unmergedRaws);
                }
            }
            catch (IOException exception) {
                this.logger.error("Data loader for {} could not read data {} from file {}", (Object)this.folderName, (Object)jsonObjectID, (Object)resourceLocation, (Object)exception);
            }
        }
        return MergeableCodecJsonDataListener.mapValues(map, this.merger::apply);
    }

    protected void apply(Map<ResourceLocation, FINE> processedData, IResourceManager resourceManager, IProfiler profiler) {
        this.logger.info("Begin loading of data for data loader: {}", (Object)this.folderName);
        this.data = processedData;
        this.logger.info("Data loader for {} loaded {} finalised jsons", (Object)this.folderName, (Object)this.data.size());
        boolean isServer = true;
        try {
            LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        }
        catch (NullPointerException e) {
            isServer = false;
        }
        if (isServer) {
            this.syncDataOnReload.ifPresent(Runnable::run);
        }
    }

    static <Key, In, Out> Map<Key, Out> mapValues(Map<Key, In> inputs, Function<In, Out> mapper) {
        HashMap newMap = new HashMap();
        inputs.forEach((key, input) -> newMap.put(key, mapper.apply(input)));
        return newMap;
    }

    public <PACKET> MergeableCodecJsonDataListener<RAW, FINE> subscribeAsSyncable(SimpleChannel channel, Function<Map<ResourceLocation, FINE>, PACKET> packetFactory) {
        MinecraftForge.EVENT_BUS.addListener(this.getLoginListener(channel, packetFactory));
        this.syncDataOnReload = Optional.of(() -> channel.send(PacketDistributor.ALL.noArg(), packetFactory.apply(this.data)));
        return this;
    }

    private <PACKET> Consumer<PlayerEvent.PlayerLoggedInEvent> getLoginListener(SimpleChannel channel, Function<Map<ResourceLocation, FINE>, PACKET> packetFactory) {
        return event -> {
            PlayerEntity player = event.getPlayer();
            if (player instanceof ServerPlayerEntity) {
                channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), packetFactory.apply(this.data));
            }
        };
    }

    private static boolean isStringJsonFile(String filename) {
        return filename.endsWith(JSON_EXTENSION);
    }

    private static void throwJsonParseException(String codecParseFailure) {
        throw new JsonParseException(codecParseFailure);
    }
}

