/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.InteriorEffectsMessage;
import net.tardis.mod.network.packets.StopHumMessage;
import net.tardis.mod.registries.InteriorHumRegistry;
import net.tardis.mod.sounds.InteriorHum;

public class InteriorEffectsHandler
implements INBTSerializable<CompoundNBT> {
    private World world;
    private InteriorHum hum = (InteriorHum)InteriorHumRegistry.DISABLED.get();
    private boolean hasHumChanged;

    public InteriorEffectsHandler(World world) {
        this.world = world;
    }

    public void setHum(InteriorHum hum) {
        InteriorHum oldHum = this.hum;
        this.stopHum(oldHum);
        this.hum = hum;
        this.hasHumChanged = true;
        this.updateClients();
    }

    public void tick() {
        if (this.shouldPlayNextHumLoop() && this.hum != null) {
            if (!this.world.field_72995_K) {
                this.updateClients();
                this.hasHumChanged = false;
            }
            if (this.world.field_72995_K) {
                if (this.hum.getLoopedSoundEvent() != null) {
                    ClientHelper.playMovingSound((Entity)ClientHelper.getClientPlayer(), this.hum.getLoopedSoundEvent(), SoundCategory.AMBIENT, 1.0f, false);
                }
                this.hasHumChanged = false;
            }
        }
    }

    public boolean shouldPlayNextHumLoop() {
        return this.hum != null && (this.hasHumChanged || this.world.func_82737_E() % (long)this.hum.getDurationInTicks() == 0L);
    }

    public void stopHum(InteriorHum oldHum) {
        if (!this.world.field_72995_K) {
            Network.sendToAllInWorld(new StopHumMessage(oldHum), (ServerWorld)this.world);
        }
    }

    public void updateClients() {
        if (!this.world.field_72995_K) {
            Network.sendToAllInWorld(new InteriorEffectsMessage(this.hum, this.hasHumChanged), (ServerWorld)this.world);
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        if (this.hum != null) {
            tag.func_74778_a("hum", this.hum.getRegistryName().toString());
        }
        tag.func_74757_a("hum_changed", this.hasHumChanged);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("hum")) {
            this.hum = (InteriorHum)InteriorHumRegistry.HUM_REGISTRY.get().getValue(new ResourceLocation(nbt.func_74779_i("hum")));
        }
        this.hasHumChanged = nbt.func_74767_n("hum_changed");
    }

    public InteriorHum getCurrentHum() {
        return this.hum;
    }

    public boolean hasHumChanged() {
        return this.hasHumChanged;
    }

    public void setHumChanged(boolean hasHumChanged) {
        this.hasHumChanged = hasHumChanged;
    }
}

