/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.tardis.mod.Tardis;
import net.tardis.mod.items.TItems;
import net.tardis.mod.recipe.TardisRecipeSerialisers;
import org.apache.logging.log4j.Logger;

public class IngredientCodec {
    public static final Codec<Ingredient> INGREDIENT_TO_JSON_CODEC = Codec.PASSTHROUGH.comapFlatMap(json -> DataResult.error((String)"Deserializing of ingredients not implemented"), ingredient -> new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)ingredient.func_200304_c()));
    public static final Codec<Ingredient> INGREDIENT_FROM_JSON_CODEC = Codec.PASSTHROUGH.flatXmap(dynamic -> {
        try {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)((JsonElement)dynamic.convert((DynamicOps)JsonOps.INSTANCE).getValue()));
            return DataResult.success((Object)ingredient);
        }
        catch (JsonSyntaxException e) {
            return DataResult.error((String)e.getMessage());
        }
    }, ingredient -> DataResult.error((String)"Cannot serialize ingredients to json with this Codec!\n Use another codec for this"));
    public static final Codec<Ingredient> INGREDIENT_CODEC = Codec.of(INGREDIENT_TO_JSON_CODEC, INGREDIENT_FROM_JSON_CODEC);

    public static void exampleImp() {
        JsonObject object = new JsonObject();
        JsonArray ingredients = new JsonArray();
        ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)TItems.ARTRON_BATTERY.get())}).func_200304_c());
        ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)TItems.FLUID_LINK.get())}).func_200304_c());
        object.add("type", (JsonElement)new JsonPrimitive(TardisRecipeSerialisers.WELD_RECIPE_TYPE_LOC.toString()));
        object.add("repair", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        object.add("ingredients", (JsonElement)ingredients);
        JsonObject resultItem = new JsonObject();
        resultItem.add("item", (JsonElement)new JsonPrimitive(((Item)TItems.ARTRON_BATTERY.get()).getRegistryName().toString()));
        object.add("result", (JsonElement)resultItem);
        INGREDIENT_CODEC.fieldOf("ingredients").codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)object).resultOrPartial(arg_0 -> ((Logger)Tardis.LOGGER).error(arg_0)).ifPresent(pair -> {
            System.out.println(((Ingredient)pair.getFirst()).func_200304_c().toString());
            System.out.println(pair.getSecond());
        });
    }
}

