/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import java.util.function.Function;
import java.util.function.Supplier;
import net.tardis.mod.client.models.interiordoors.IInteriorDoorRenderer;
import net.tardis.mod.enums.EnumDoorState;

public interface IDoorType {
    public EnumDoorState[] getValidStates();

    public double getRotationForState(EnumDoorState var1);

    public void setInteriorDoorModel(IInteriorDoorRenderer var1);

    public IInteriorDoorRenderer getInteriorDoorRenderer();

    public static enum EnumDoorType implements IDoorType
    {
        STEAM(state -> {
            switch (state) {
                case CLOSED: {
                    return 0.0;
                }
                case ONE: {
                    return 55.0;
                }
            }
            return 85.0;
        }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
        TRUNK(state -> {
            switch (state) {
                case CLOSED: {
                    return 0.0;
                }
                case ONE: {
                    return -55.0;
                }
            }
            return -85.0;
        }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
        TELEPHONE(state -> {
            switch (state) {
                case CLOSED: {
                    return 0.0;
                }
                case ONE: {
                    return 55.0;
                }
            }
            return 85.0;
        }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
        POLICE_BOX(state -> {
            switch (state) {
                case CLOSED: {
                    return 0.0;
                }
                case ONE: {
                    return 90.0;
                }
                case BOTH: {
                    return -90.0;
                }
            }
            return 0.0;
        }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
        MODERN_POLICE_BOX(state -> {
            switch (state) {
                case CLOSED: {
                    return 0.0;
                }
                case ONE: {
                    return 75.0;
                }
                case BOTH: {
                    return -75.0;
                }
            }
            return 0.0;
        }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
        FORTUNE(state -> {
            switch (state) {
                case CLOSED: {
                    return 0.0;
                }
                case ONE: {
                    return -55.0;
                }
            }
            return -85.0;
        }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
        SAFE(state -> {
            switch (state) {
                case CLOSED: {
                    return 0.0;
                }
                case ONE: {
                    return -55.0;
                }
            }
            return -85.0;
        }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
        TT_CAPSULE(state -> {
            switch (state) {
                case CLOSED: {
                    return 0.0;
                }
                case ONE: {
                    return 45.0;
                }
            }
            return 85.0;
        }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
        CLOCK(state -> {
            switch (state) {
                case CLOSED: {
                    return 0.0;
                }
                case ONE: {
                    return -55.0;
                }
            }
            return -85.0;
        }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
        TT_2020_CAPSULE(state -> {
            switch (state) {
                case CLOSED: {
                    return 0.0;
                }
                case ONE: {
                    return -30.0;
                }
            }
            return -60.0;
        }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
        JAPAN(state -> {
            switch (state) {
                case CLOSED: {
                    return 0.0;
                }
                case ONE: {
                    return -0.2;
                }
                case BOTH: {
                    return -0.5;
                }
            }
            return 0.0;
        }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH),
        APERTURE(state -> {
            switch (state) {
                default: {
                    return 0.0;
                }
                case ONE: {
                    return 50.0;
                }
                case BOTH: 
            }
            return 50.0;
        }, EnumDoorState.CLOSED, EnumDoorState.ONE, EnumDoorState.BOTH);

        Function<EnumDoorState, Double> func;
        EnumDoorState[] validStates;
        Supplier<Supplier<IInteriorDoorRenderer>> renderer;

        private EnumDoorType(Function<EnumDoorState, Double> func, EnumDoorState ... states) {
            this.validStates = states;
            this.func = func;
        }

        @Override
        public EnumDoorState[] getValidStates() {
            return this.validStates;
        }

        @Override
        public double getRotationForState(EnumDoorState state) {
            return this.func.apply(state);
        }

        @Override
        public void setInteriorDoorModel(IInteriorDoorRenderer renderer) {
            this.renderer = () -> () -> renderer;
        }

        @Override
        public IInteriorDoorRenderer getInteriorDoorRenderer() {
            return this.renderer.get().get();
        }
    }
}

