/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;

public class GenericJsonDataListener<T>
extends JsonReloadListener {
    protected final String folderName;
    protected Class<T> dataClass;
    protected final Logger logger;
    protected static final Gson STANDARD_GSON = new Gson();
    protected Map<ResourceLocation, T> data = new HashMap<ResourceLocation, T>();
    protected Optional<Runnable> syncDataOnReload = Optional.empty();
    private Function<JsonElement, T> mapper;

    public GenericJsonDataListener(String folderName, Class<T> dataClass, Logger logger, Gson gson, Function<JsonElement, T> mapper) {
        super(gson, folderName);
        this.folderName = folderName;
        this.dataClass = dataClass;
        this.logger = logger;
        this.mapper = mapper;
    }

    public GenericJsonDataListener(String folderName, Class<T> dataClass, Logger logger, Function<JsonElement, T> mapper) {
        this(folderName, dataClass, logger, STANDARD_GSON, mapper);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        this.logger.info("Beginning loading of data for data loader: {}", (Object)this.folderName);
        this.data = this.mapValues(jsons, this::getJsonAsData);
        this.logger.info("Data loader for {} loaded {} entries", (Object)this.folderName, (Object)this.data.size());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            this.syncDataOnReload.ifPresent(Runnable::run);
        }
    }

    public Map<ResourceLocation, T> mapValues(Map<ResourceLocation, JsonElement> inputs, Function<JsonElement, T> mapper) {
        HashMap newMap = new HashMap();
        inputs.forEach((key, input) -> {
            newMap.put(key, mapper.apply((JsonElement)input));
            this.logger.info("Added: {}", (Object)key.toString());
        });
        return newMap;
    }

    protected T getJsonAsData(JsonElement json) {
        return this.mapper.apply(json);
    }

    public <PACKET> GenericJsonDataListener<T> subscribeAsSyncable(SimpleChannel channel, Function<Map<ResourceLocation, T>, PACKET> packetFactory) {
        MinecraftForge.EVENT_BUS.addListener(this.getLoginListener(channel, packetFactory));
        this.syncDataOnReload = Optional.of(() -> channel.send(PacketDistributor.ALL.noArg(), packetFactory.apply(this.data)));
        return this;
    }

    private <PACKET> Consumer<PlayerEvent.PlayerLoggedInEvent> getLoginListener(SimpleChannel channel, Function<Map<ResourceLocation, T>, PACKET> packetFactory) {
        return event -> {
            PlayerEntity player = event.getPlayer();
            if (player instanceof ServerPlayerEntity) {
                channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), packetFactory.apply(this.data));
            }
        };
    }

    public Map<ResourceLocation, T> getData() {
        return this.data;
    }

    public void setData(Map<ResourceLocation, T> input) {
        this.data = input;
    }
}

