/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tardis.mod.Tardis;
import org.apache.logging.log4j.Level;

public class Disguise
extends ForgeRegistryEntry<Disguise> {
    BiFunction<World, BlockPos, Boolean> isValid = (world, pos) -> false;
    private Supplier<BlockState> top;
    private Supplier<BlockState> bottom;
    private HashMap<BlockPos, BlockState> blocks = new HashMap();
    private int width;
    private int height;

    public Disguise(Supplier<BlockState> top, Supplier<BlockState> bottom) {
        this.top = top;
        this.bottom = bottom;
    }

    public Disguise(Supplier<BlockState> both) {
        this(both, both);
    }

    public void readData(IResourceManager resourceManager, ResourceLocation registryName) {
        try {
            this.blocks.clear();
            IResource resource = resourceManager.func_199002_a(new ResourceLocation(registryName.func_110624_b(), "disguises/" + registryName.func_110623_a() + ".json"));
            JsonArray root = new JsonParser().parse((Reader)new InputStreamReader(resource.func_199027_b())).getAsJsonArray();
            for (JsonElement ele : root) {
                JsonObject obj = ele.getAsJsonObject();
                DisguiseBlockStateEntry.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).get().ifLeft(result -> {
                    DisguiseBlockStateEntry entry = (DisguiseBlockStateEntry)result.getFirst();
                    BlockState state = entry.getBlockState();
                    int x = entry.getOffset().func_177958_n();
                    int y = entry.getOffset().func_177956_o();
                    int z = entry.getOffset().func_177952_p();
                    this.blocks.put(new BlockPos(x, y, z).func_185334_h(), state);
                }).ifRight(partial -> Tardis.LOGGER.error("Failed to parse data json for {} due to: {}", (Object)registryName.toString(), (Object)partial.message()));
            }
            resource.close();
        }
        catch (Exception e) {
            Tardis.LOGGER.catching(Level.DEBUG, (Throwable)e);
        }
        for (BlockPos pos : this.blocks.keySet()) {
            if (Math.abs(pos.func_177958_n()) > this.width) {
                this.width = Math.abs(pos.func_177958_n());
            }
            if (Math.abs(pos.func_177952_p()) > this.width) {
                this.width = Math.abs(pos.func_177952_p());
            }
            if (pos.func_177956_o() <= this.height) continue;
            this.height = pos.func_177956_o();
        }
    }

    public void setValidationFunction(BiFunction<World, BlockPos, Boolean> func) {
        this.isValid = func;
    }

    public BlockState getTopState() {
        return this.top.get();
    }

    public BlockState getBottomState() {
        return this.bottom.get();
    }

    public HashMap<BlockPos, BlockState> getOtherBlocks() {
        return this.blocks;
    }

    public boolean getIsValid(World world, BlockPos pos) {
        return this.isValid.apply(world, pos);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static class DisguiseBlockStateEntry {
        public static final Codec<DisguiseBlockStateEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.field_235877_b_.fieldOf("block").forGetter(DisguiseBlockStateEntry::getBlockState), (App)Codec.INT.fieldOf("x").forGetter(offset -> offset.getOffset().func_177958_n()), (App)Codec.INT.fieldOf("y").forGetter(offset -> offset.getOffset().func_177956_o()), (App)Codec.INT.fieldOf("z").forGetter(offset -> offset.getOffset().func_177952_p())).apply((Applicative)instance, DisguiseBlockStateEntry::new));
        public static final Codec<List<DisguiseBlockStateEntry>> CODEC_LIST = CODEC.listOf();
        private BlockPos offset;
        private BlockState blockState;

        public DisguiseBlockStateEntry(BlockState state, BlockPos offset) {
            this.blockState = state;
            this.offset = offset;
        }

        public DisguiseBlockStateEntry(BlockState state, int x, int y, int z) {
            this.blockState = state;
            this.offset = new BlockPos(x, y, z);
        }

        public BlockPos getOffset() {
            return this.offset;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        public static void deserialise() {
        }
    }
}

