/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.misc.CodecJsonDataListener;
import org.apache.logging.log4j.Logger;

public class ConsoleRoomCodecListener
extends CodecJsonDataListener<ConsoleRoom> {
    public ConsoleRoomCodecListener(String folderName, Codec<ConsoleRoom> codec, Logger logger) {
        super(folderName, codec, logger);
    }

    @Override
    public Map<ResourceLocation, ConsoleRoom> mapValues(Map<ResourceLocation, JsonElement> inputs) {
        Map<ResourceLocation, ConsoleRoom> map = ConsoleRoom.registerCoreConsoleRooms();
        HashMap parsedInData = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : inputs.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> {
                ((ConsoleRoom)result.getFirst()).setRegistryName(key);
                parsedInData.put(key, result.getFirst());
                this.logger.info("Added Datapack entry: {}", (Object)key.toString());
            }).ifRight(partial -> this.logger.error("Failed to parse data json for {} due to: {}", (Object)key.toString(), (Object)partial.message()));
        }
        map.putAll(parsedInData);
        return map;
    }

    @Override
    public void setData(Map<ResourceLocation, ConsoleRoom> input) {
        for (Map.Entry<ResourceLocation, ConsoleRoom> entry : input.entrySet()) {
            entry.getValue().setRegistryName(entry.getKey());
        }
        super.setData(input);
    }
}

