/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;

public class CodecJsonDataListener<T>
extends JsonReloadListener {
    protected final String folderName;
    protected Codec<T> codec;
    protected final Logger logger;
    protected static final Gson STANDARD_GSON = new Gson();
    protected Map<ResourceLocation, T> data = new HashMap<ResourceLocation, T>();
    protected Optional<Runnable> syncDataOnReload = Optional.empty();

    public CodecJsonDataListener(String folderName, Codec<T> codec, Logger logger, Gson gson) {
        super(gson, folderName);
        this.folderName = folderName;
        this.codec = codec;
        this.logger = logger;
    }

    public CodecJsonDataListener(String folderName, Codec<T> codec, Logger logger) {
        this(folderName, codec, logger, STANDARD_GSON);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        this.logger.info("Beginning loading of data for data loader: {}", (Object)this.folderName);
        this.data = this.mapValues(jsons);
        this.logger.info("Data loader for {} loaded {} entries", (Object)this.folderName, (Object)this.data.size());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            this.syncDataOnReload.ifPresent(Runnable::run);
        }
    }

    public Map<ResourceLocation, T> mapValues(Map<ResourceLocation, JsonElement> inputs) {
        HashMap newMap = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : inputs.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> {
                newMap.put(key, result.getFirst());
                this.logger.info("Added: {}", (Object)key.toString());
            }).ifRight(partial -> this.logger.error("Failed to parse data json for {} due to: {}", (Object)key.toString(), (Object)partial.message()));
        }
        return newMap;
    }

    public <PACKET> CodecJsonDataListener<T> subscribeAsSyncable(SimpleChannel channel, Function<Map<ResourceLocation, T>, PACKET> packetFactory) {
        MinecraftForge.EVENT_BUS.addListener(this.getLoginListener(channel, packetFactory));
        this.syncDataOnReload = Optional.of(() -> channel.send(PacketDistributor.ALL.noArg(), packetFactory.apply(this.data)));
        return this;
    }

    private <PACKET> Consumer<PlayerEvent.PlayerLoggedInEvent> getLoginListener(SimpleChannel channel, Function<Map<ResourceLocation, T>, PACKET> packetFactory) {
        return event -> {
            PlayerEntity player = event.getPlayer();
            if (player instanceof ServerPlayerEntity) {
                channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), packetFactory.apply(this.data));
            }
        };
    }

    public Map<ResourceLocation, T> getData() {
        return this.data;
    }

    public void setData(Map<ResourceLocation, T> input) {
        this.data = input;
    }
}

