/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.misc.Console;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.BrokenExteriorTile;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.EmotionHandler;

public class BrokenExteriorType
extends ForgeRegistryEntry<BrokenExteriorType> {
    Supplier<AbstractExterior> exterior;
    Supplier<ConsoleRoom> interior;
    Supplier<Console> consoleBlock;
    Supplier<ConsoleRoom[]> unlockedRooms;

    public BrokenExteriorType(Supplier<AbstractExterior> exterior, Supplier<Console> consoleBlock, Supplier<ConsoleRoom> room, Supplier<ConsoleRoom[]> unlockedRooms) {
        this.exterior = exterior;
        this.interior = room;
        this.consoleBlock = consoleBlock;
        this.unlockedRooms = unlockedRooms;
    }

    public void swapWithReal(ServerWorld world, BlockPos pos, World interior, Direction dir) {
        TardisHelper.getConsole(world.func_73046_m(), interior).ifPresent(tile -> {
            tile.setExteriorType(this.exterior.get());
            tile.getUnlockManager().addExterior(this.exterior.get());
            tile.getUnlockManager().addConsole(this.consoleBlock.get());
            tile.setCurrentLocation((RegistryKey<World>)world.func_234923_W_(), pos.func_177977_b());
            tile.setDestination((RegistryKey<World>)world.func_234923_W_(), pos.func_177977_b());
            tile.setExteriorFacingDirection(dir);
            tile.getExteriorType().place((ConsoleTile)((Object)tile), (RegistryKey<World>)world.func_234923_W_(), pos.func_177977_b());
            tile.getExteriorType().getExteriorTile((ConsoleTile)((Object)tile)).setInteriorDimensionKey(interior);
            tile.getExteriorType().getExteriorTile((ConsoleTile)((Object)tile)).setDoorState(EnumDoorState.ONE);
        });
    }

    public ServerWorld setup(ServerWorld world, ServerPlayerEntity player, BrokenExteriorTile ext) {
        ServerWorld tardisWorld = TardisHelper.setupTardisDim(world.func_73046_m(), this.consoleBlock.get().getState(), this.interior.get());
        world.func_184133_a(null, ext.func_174877_v(), (SoundEvent)TSounds.DOOR_UNLOCK.get(), SoundCategory.BLOCKS, 0.75f, 1.0f);
        TardisHelper.getConsoleInWorld((World)tardisWorld).ifPresent(tile -> {
            ConsoleRoom[] rooms;
            for (ConsoleRoom room : rooms = this.unlockedRooms.get()) {
                if (room == null) continue;
                tile.getUnlockManager().addConsoleRoom(room);
            }
            tile.getUnlockManager().addConsole(this.consoleBlock.get());
            if (this.interior.get() != null) {
                tile.setConsoleRoom(this.interior.get());
            }
            HashMap<UUID, Integer> extLoyalties = ext.getLoyalties();
            EmotionHandler emotionHandler = tile.getEmotionHandler();
            for (Map.Entry<UUID, Integer> entry : extLoyalties.entrySet()) {
                UUID key = entry.getKey();
                int value = entry.getValue();
                emotionHandler.addLoyalty(key, value);
            }
        });
        return tardisWorld;
    }

    public void spawnHappyPart(World world, BlockPos pos) {
        for (int i = 0; i < 18; ++i) {
            double angle = Math.toRadians(i * 20);
            double x = Math.sin(angle);
            double z = Math.cos(angle);
            world.func_195594_a((IParticleData)ParticleTypes.field_197633_z, (double)pos.func_177958_n() + 0.5 + x, (double)pos.func_177956_o() + world.func_201674_k().nextDouble(), (double)pos.func_177952_p() + 0.5 + z, 0.0, 0.0, 0.0);
        }
    }
}

