/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.items.misc.AttunableItem;
import net.tardis.mod.items.misc.IAttunable;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.AttunementProgressMessage;
import net.tardis.mod.recipe.AttunableRecipe;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.inventory.PanelInventory;
import net.tardis.mod.tileentities.inventory.PanelInventoryWrapper;

public class AttunementHandler {
    public static final int ATTUNEMENT_SLOT = 4;
    private Supplier<PanelInventory> inventorySupplier;
    private World world;
    private int currentAttunementTime;
    private int maxAttunementTime;
    private AttunableRecipe recipe;
    private float clientAttunementProgress = 0.0f;

    public AttunementHandler(Supplier<PanelInventory> inv, World world) {
        this.inventorySupplier = inv;
        this.world = world;
    }

    public void tick(ConsoleTile tile) {
        if (this.isAttuning()) {
            this.maxAttunementTime = this.getMaxAttunementTicks();
            ++this.currentAttunementTime;
            if (this.currentAttunementTime >= this.maxAttunementTime) {
                this.complete(tile);
            } else {
                this.updateClients();
            }
        } else if (this.needsResetProgress()) {
            this.resetAttuning(ItemStack.field_190927_a);
        }
    }

    public boolean needsResetProgress() {
        return this.currentAttunementTime != 0 || this.maxAttunementTime != 0;
    }

    public boolean isAttuning() {
        if (this.getAttuningItem().func_77973_b() instanceof IAttunable) {
            return true;
        }
        this.recipe = this.findRecipe();
        return this.recipe != null && this.recipe != AttunableRecipe.EMPTY_RECIPE;
    }

    public void complete(ConsoleTile tile) {
        ItemStack attuningItem = this.getAttuningItem();
        if (attuningItem.func_77973_b() instanceof IAttunable) {
            this.inventorySupplier.get().setStackInSlot(4, ((IAttunable)attuningItem.func_77973_b()).onAttuned(attuningItem, tile));
        }
        if (this.recipe != null && this.recipe != AttunableRecipe.EMPTY_RECIPE) {
            ItemStack resultStack = this.recipe.func_77571_b();
            if (attuningItem.func_190916_E() > this.recipe.func_77571_b().func_190916_E()) {
                resultStack.func_190920_e(attuningItem.func_190916_E());
            }
            this.inventorySupplier.get().setStackInSlot(4, this.recipe.shouldAddNBTTags() ? AttunableItem.completeAttunement(resultStack, tile) : resultStack);
            this.recipe = AttunableRecipe.EMPTY_RECIPE;
        }
        this.resetAttuning(ItemStack.field_190927_a);
        this.world.func_184133_a(null, tile.func_174877_v(), (SoundEvent)TSounds.REACHED_DESTINATION.get(), SoundCategory.BLOCKS, 0.3f, 1.0f);
    }

    public void serialize(CompoundNBT nbt) {
        nbt.func_74768_a("attunement_ticks", this.currentAttunementTime);
    }

    public void deserialize(CompoundNBT nbt) {
        this.currentAttunementTime = nbt.func_74762_e("attunement_ticks");
    }

    public ItemStack getAttuningItem() {
        return this.inventorySupplier.get().getStackInSlot(4);
    }

    public void resetAttuning(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            this.currentAttunementTime = 0;
            this.maxAttunementTime = 0;
            return;
        }
        if (itemStack.func_77973_b() instanceof IAttunable) {
            this.currentAttunementTime = 0;
            this.clientAttunementProgress = 0.0f;
            this.maxAttunementTime = ((IAttunable)itemStack.func_77973_b()).getAttunementTime();
        }
        if (this.recipe == AttunableRecipe.EMPTY_RECIPE) {
            this.currentAttunementTime = 0;
            this.clientAttunementProgress = 0.0f;
            this.maxAttunementTime = this.recipe.getAttunementTicks();
        }
        this.updateClients();
    }

    public AttunableRecipe findRecipe() {
        if (this.recipe == AttunableRecipe.EMPTY_RECIPE || this.recipe == null) {
            for (AttunableRecipe recipe : AttunableRecipe.getAllRecipes(this.world)) {
                if (!recipe.matches(new PanelInventoryWrapper(this.inventorySupplier.get()), this.world)) continue;
                this.recipe = recipe;
            }
        }
        return this.recipe;
    }

    public int getCurrentAttunementTime() {
        return this.currentAttunementTime;
    }

    public int getMaxAttunementTicks() {
        ItemStack stack = this.getAttuningItem();
        if (stack.func_77973_b() instanceof IAttunable) {
            return ((IAttunable)stack.func_77973_b()).getAttunementTime();
        }
        this.recipe = this.findRecipe();
        if (this.recipe != null && this.recipe != AttunableRecipe.EMPTY_RECIPE) {
            if (stack.func_190916_E() > this.recipe.func_77571_b().func_190916_E()) {
                int adjustedTime = this.recipe.getAttunementTicks() * stack.func_190916_E();
                return adjustedTime;
            }
            return this.recipe.getAttunementTicks();
        }
        return 0;
    }

    public void updateClients() {
        Network.sendToAllInWorld(new AttunementProgressMessage((float)this.currentAttunementTime / (float)this.maxAttunementTime), (ServerWorld)this.world);
    }

    public float getClientAttunementProgress() {
        return this.clientAttunementProgress;
    }

    public void setClientAttunementProgress(float progress) {
        this.clientAttunementProgress = progress;
    }
}

