/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.misc;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.ars.ARSPiece;
import net.tardis.mod.misc.CodecJsonDataListener;
import org.apache.logging.log4j.Logger;

public class ARSPieceCodecListener
extends CodecJsonDataListener<ARSPiece> {
    public ARSPieceCodecListener(String folderName, Codec<ARSPiece> codec, Logger logger) {
        super(folderName, codec, logger);
    }

    @Override
    public Map<ResourceLocation, ARSPiece> mapValues(Map<ResourceLocation, JsonElement> inputs) {
        Map<ResourceLocation, ARSPiece> map = ARSPiece.registerCoreARSPieces();
        HashMap parsedInData = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : inputs.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> {
                ((ARSPiece)result.getFirst()).setRegistryName(key);
                parsedInData.put(key, result.getFirst());
                this.logger.info("Added Datapack entry: {}", (Object)key.toString());
            }).ifRight(partial -> this.logger.error("Failed to parse data json for {} due to: {}", (Object)key.toString(), (Object)partial.message()));
        }
        map.putAll(parsedInData);
        return map;
    }

    @Override
    public void setData(Map<ResourceLocation, ARSPiece> input) {
        for (Map.Entry<ResourceLocation, ARSPiece> entry : input.entrySet()) {
            entry.getValue().setRegistryName(entry.getKey());
        }
        super.setData(input);
    }
}

