/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items.misc;

import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.items.BaseItem;
import net.tardis.mod.misc.IItemTooltipProvider;

public class TooltipProviderItem
extends BaseItem
implements IItemTooltipProvider {
    protected boolean shouldShowTooltips = false;
    protected boolean hasStatisticsTooltips = false;
    protected boolean hasDescriptionTooltips = false;

    public TooltipProviderItem(Item.Properties properties, boolean showTooltips) {
        super(properties);
        this.shouldShowTooltips = showTooltips;
    }

    public TooltipProviderItem(Item.Properties properties) {
        this(properties, true);
    }

    public TooltipProviderItem() {
        super(new Item.Properties().func_200916_a(TItemGroups.MAIN));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.shouldShowTooltips()) {
            this.createDefaultTooltips(stack, worldIn, tooltip, flagIn);
            if (this.hasStatisticsTooltips()) {
                tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_HOLD_SHIFT);
                if (Screen.func_231173_s_()) {
                    tooltip.clear();
                    tooltip.add(0, this.func_200295_i(stack));
                    this.createStatisticTooltips(stack, worldIn, tooltip, flagIn);
                }
            }
            if (this.hasDescriptionTooltips()) {
                tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_CONTROL);
                if (Screen.func_231172_r_()) {
                    tooltip.clear();
                    tooltip.add(0, this.func_200295_i(stack));
                    this.createDescriptionTooltips(stack, worldIn, tooltip, flagIn);
                }
            }
        }
    }

    @Override
    public void createStatisticTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    @Override
    public void createDescriptionTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    @Override
    public void createDefaultTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    @Override
    public boolean shouldShowTooltips() {
        return this.shouldShowTooltips;
    }

    @Override
    public void setShowTooltips(boolean showTooltips) {
        this.shouldShowTooltips = showTooltips;
    }

    @Override
    public boolean hasStatisticsTooltips() {
        return this.hasStatisticsTooltips;
    }

    @Override
    public void setHasStatisticsTooltips(boolean hasStatisticsTooltips) {
        this.hasStatisticsTooltips = hasStatisticsTooltips;
    }

    @Override
    public boolean hasDescriptionTooltips() {
        return this.hasDescriptionTooltips;
    }

    @Override
    public void setHasDescriptionTooltips(boolean hasDescriptionTooltips) {
        this.hasDescriptionTooltips = hasDescriptionTooltips;
    }
}

