/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items.misc;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.tardis.mod.damagesources.TDamageSources;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.projectiles.LaserEntity;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.LaserGunItem;
import net.tardis.mod.items.TItems;
import net.tardis.mod.items.misc.GenericLaserWeapon;
import net.tardis.mod.items.misc.LaserPowerTier;
import net.tardis.mod.sounds.TSounds;

public class PlayerLaserWeapon
extends GenericLaserWeapon<LivingEntity> {
    public PlayerLaserWeapon(LivingEntity user) {
        super(user);
    }

    @Override
    public void onHitEntityPre(LaserEntity laserEntity, Entity hitEntity) {
        if (!this.user.field_70170_p.func_201670_d()) {
            LaserGunItem laserGun;
            LaserPowerTier tier;
            ItemStack stack;
            PlayerEntity player;
            if (hitEntity instanceof PlayerEntity && ((player = (PlayerEntity)hitEntity).func_184592_cb().func_77973_b() instanceof ShieldItem || player.func_184614_ca().func_77973_b() instanceof ShieldItem)) {
                ItemStack heldStack = PlayerHelper.isInMainHand(this.user, (Item)TItems.EARTHSHOCK_GUN.get()) ? this.user.func_184614_ca() : this.user.func_184592_cb();
                WorldHelper.maybeDisableShieldNoEnchant(player, this.user, heldStack, player.func_184592_cb());
            }
            ItemStack itemStack = stack = !this.user.func_184614_ca().func_190926_b() ? this.user.func_184614_ca() : this.user.func_184592_cb();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof LaserGunItem && (tier = (laserGun = (LaserGunItem)stack.func_77973_b()).getCurrentTier(stack)) == LaserPowerTier.HIGH && this.user.field_70170_p.field_73012_v.nextFloat() <= 0.25f) {
                hitEntity.func_70015_d(5);
            }
        }
    }

    @Override
    public void onHit(LaserEntity laserEntity, RayTraceResult result) {
    }

    @Override
    public boolean useWeapon(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            ItemStack stack;
            ItemStack itemStack = stack = !entity.func_184614_ca().func_190926_b() ? entity.func_184614_ca() : entity.func_184592_cb();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof LaserGunItem) {
                float soundPitch = 1.0f;
                LaserEntity laser = new LaserEntity((EntityType<? extends ThrowableEntity>)((EntityType)TEntities.LASER.get()), entity, entity.field_70170_p, this.damage(), TDamageSources.causeTardisMobDamage("laser", entity));
                LaserGunItem laserGun = (LaserGunItem)stack.func_77973_b();
                LaserPowerTier tier = laserGun.getCurrentTier(stack);
                laser.func_234612_a_((Entity)laser, entity.field_70125_A, entity.field_70759_as, 0.0f, tier.getVelocity(), 0.1f);
                laser.setRayLength(tier.getLaserLength());
                laser.setColor(tier.getLaserColour());
                soundPitch = tier.getSoundPitch();
                laser.setWeaponType(this);
                entity.field_70170_p.func_217376_c((Entity)laser);
                laserGun.removeCharge((Entity)entity, stack, tier.getChargeRequired());
                entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)TSounds.LASER_GUN_FIRE.get(), SoundCategory.HOSTILE, 1.0f, soundPitch);
                if (entity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entity;
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184811_cZ().func_185145_a(laserGun.getItem(), tier.getCooldownTicks());
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

