/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items.misc;

import net.minecraft.util.math.vector.Vector3d;

public enum LaserPowerTier {
    LOW(8.0f, 20.0f, 0.75f, new Vector3d(1.0, 0.0, 0.0), 1.0f, 0.8f, 5, "low"),
    MEDIUM(14.0f, 40.0f, 1.5f, new Vector3d(0.0, 1.0, 0.0), 2.0f, 1.0f, 10, "medium"),
    HIGH(20.0f, 60.0f, 1.75f, new Vector3d(0.0, 0.0, 1.0), 3.0f, 1.25f, 25, "high");

    float damageInflicted = 5.0f;
    float chargeRequired = 0.0f;
    int cooldownTicks = 20;
    float velocity = 1.5f;
    Vector3d laserColour = new Vector3d(1.0, 1.0, 1.0);
    float soundPitch = 1.0f;
    float laserLength = 2.0f;
    String translationKey = "power_tier.tardis";

    private LaserPowerTier(float damage, float chargeRequired, float velocity, Vector3d laserColour, float laserLength, float soundPitch, int cooldownTicks, String translationKey) {
        this.damageInflicted = damage;
        this.chargeRequired = chargeRequired;
        this.velocity = velocity;
        this.laserColour = laserColour;
        this.laserLength = laserLength;
        this.soundPitch = soundPitch;
        this.cooldownTicks = cooldownTicks;
        this.translationKey = "laser_power_tier.tardis." + translationKey;
    }

    public float getDamageInflicted() {
        return this.damageInflicted;
    }

    public float getChargeRequired() {
        return this.chargeRequired;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public Vector3d getLaserColour() {
        return this.laserColour;
    }

    public float getLaserLength() {
        return this.laserLength;
    }

    public float getSoundPitch() {
        return this.soundPitch;
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }
}

