/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items.misc;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.tardis.mod.damagesources.TDamageSources;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.projectiles.LaserEntity;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.misc.AbstractWeapon;
import net.tardis.mod.sounds.TSounds;

public class GenericLaserWeapon<T extends LivingEntity>
extends AbstractWeapon<T> {
    protected T user;
    protected DamageSource source;
    protected Vector3d laserColour;
    protected float damage;
    protected float rayLength;
    protected SoundEvent sound;

    public GenericLaserWeapon(T user, DamageSource source, float damage, Vector3d colour, float rayLength, SoundEvent sound) {
        this.user = user;
        this.source = source;
        this.laserColour = colour;
        this.damage = damage;
        this.rayLength = rayLength;
        this.sound = sound;
    }

    public GenericLaserWeapon(T user) {
        this(user, TDamageSources.causeTardisMobDamage("laser", user), 5.0f, new Vector3d(0.0, 1.0, 1.0), 1.0f, (SoundEvent)TSounds.LASER_GUN_FIRE.get());
    }

    @Override
    public void onHitEntityPre(LaserEntity laserEntity, Entity hitEntity) {
        PlayerEntity player;
        if (!((LivingEntity)this.user).field_70170_p.func_201670_d() && hitEntity instanceof PlayerEntity && ((player = (PlayerEntity)hitEntity).func_184592_cb().func_77973_b() instanceof ShieldItem || player.func_184614_ca().func_77973_b() instanceof ShieldItem)) {
            ItemStack heldStack = PlayerHelper.isInMainHand(this.user, (Item)TItems.EARTHSHOCK_GUN.get()) ? this.user.func_184614_ca() : this.user.func_184592_cb();
            WorldHelper.maybeDisableShieldNoEnchant(player, this.user, heldStack, player.func_184592_cb());
        }
    }

    @Override
    public float damage() {
        return this.damage;
    }

    @Override
    public boolean useWeapon(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            LaserEntity laser = new LaserEntity((EntityType<? extends ThrowableEntity>)((EntityType)TEntities.LASER.get()), entity, entity.field_70170_p, this.damage(), this.source);
            laser.func_234612_a_((Entity)laser, entity.field_70125_A, entity.field_70759_as, 0.0f, 1.5f, 0.1f);
            laser.setRayLength(this.rayLength);
            laser.setColor(this.laserColour);
            laser.setWeaponType(this);
            entity.field_70170_p.func_217376_c((Entity)laser);
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), this.sound, SoundCategory.HOSTILE, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

